// Safe demonstration: shows that Bio-Formats attempts to deserialize .bfmemo.
// No gadget chains, no malicious payloads.

import loci.formats.Memoizer;
import loci.formats.ImageReader;

public class DemoMemoizer {
  public static void main(String[] args) throws Exception {
    if (args.length != 1) {
      System.out.println("Usage: java DemoMemoizer <path-to-image>");
      System.exit(2);
    }

    String imagePath = args[0];

    // Memoizer wraps a reader and will try to use memoization caches (.bfmemo)
    ImageReader reader = new ImageReader();
    Memoizer memo = new Memoizer(reader);

    System.out.println("[INFO] Opening: " + imagePath);
    try {
      memo.setId(imagePath);
      System.out.println("[INFO] Opened (this demonstrates memoization path executed).");
      System.exit(0);
    } catch (Exception e) {
      System.out.println("[INFO] Exception while opening (still demonstrates code path reached): " + e);
      System.exit(1);
    } finally {
      try { memo.close(); } catch (Exception ignored) {}
    }
  }
}
