# 🛡️ CVE-2026-21509 — Microsoft Office Zero-Day

![OFFICE](https://github.com/user-attachments/assets/6bca6072-f224-4d85-af55-a7d9b5152e36)

> **Status:** Actively exploited → Emergency patch released
> **Severity:** 🔴 High
> **Risk Type:** Security Feature Bypass

---

## 🔍 What is it?

**CVE-2026-21509** is a serious vulnerability in **Microsoft Office** that allows attackers to **bypass built-in security protections** by tricking Office into trusting malicious files.

Once opened, these files can:

* Slip past safety controls
* Load hidden embedded content
* Enable follow-up attacks like malware installation

---

## 📌 Key Details

| Field                | Value                     |
| -------------------- | ------------------------- |
| **CVE ID**           | CVE-2026-21509            |
| **Category**         | Security Feature Bypass   |
| **Exploitation**     | Confirmed in the wild     |
| **User Interaction** | Required (must open file) |
| **Preview Pane**     | ❌ Not affected            |

---

## 💻 Affected Products

* Microsoft Office 2016
* Microsoft Office 2019
* Office LTSC 2021
* Office LTSC 2024
* Microsoft 365 Apps for Enterprise

---

## ⚠️ How attacks work

Attackers send **malicious Word or Excel documents** via phishing or social engineering.
When a user opens the file, Office’s trust mechanisms are bypassed — making it easier to run harmful content.


---------------------------------

### 🛠️ How to Use & Test

1. **Install**: `pip install python-docx olefile`
 
2. **Run**: `python3 CVE-2026-21509.py --output test.docx --clsid YOUR_CLSID`
 
3. **Test**: Open `test.docx` in vulnerable Office VM (pre-patch). Monitor with ProcMon; if bypass works, OLE loads without block prompt.
 
4. **Enhance**:
   - Use `oletools` (`pip install oletools`): `rtfobj` to craft RTF OLE, or `olevba` to add VBA auto-run.
   - Replace CLSID with unsafe COM (e.g., MSCOMCTL.OCX controls) from OleViewDotNet.
   - For full bypass: Embed ActiveX with malicious properties (research OLE exploits like CVE-2017-11882 for patterns).
   - Apply registry kill bit (as in advisory) → re-test to confirm block.


-----------------------------------

If the Python PoC for **CVE-2026-21509** works successfully (on a system with the required libraries installed), here's exactly what you'd see step by step:

### 1. **Running the Script** (Terminal Output)

```bash
python3 CVE-2026-21509.py --output test.docx --clsid EAB22AC3-30C1-11CF-A7EB-0000C05BAE0B
```

**Expected Success Output**:

```
OLE binary saved as embedded_ole.bin (embed manually in DOCX if needed via tools like oletools)
Generated malicious DOCX: test.docx
Open in vulnerable Office (pre-patch) to test bypass. Use isolated VM!
```

- **Key Signs**:
  - No errors (e.g., no `ImportError`, `OSError`, or XML issues).
  - Two files created: `test.docx` (the malicious document) and `embedded_ole.bin` (the OLE stream for reference).
  - The script runs in seconds (quick file generation).

If it fails (e.g., missing `python-docx` or `olefile`):

```
ModuleNotFoundError: No module named 'docx'
```

Fix: `pip install python-docx olefile`

### 2. **Opening the Generated DOCX in Vulnerable Office**

- **On Vulnerable Office** (pre-Jan 26, 2026 patch, e.g., Office 2016/2019 unpatched):
  - The file opens normally (no Protected View prompt if bypassed, or no "Blocked" OLE warning).
  - The embedded OLE object loads silently or shows a placeholder icon/content.
  - **Success Indicators** (via monitoring tools):
    - ProcMon (Process Monitor): Look for OLE-related registry reads (e.g., under `HKCR\CLSID\{EAB22AC3-...}`) without block events.
    - No "Security Warning" dialog for OLE controls.
    - If payload is extended (e.g., with VBA or shellcode in real research): Potential code execution (e.g., calc.exe pops, file written, etc.).
  - **Visual**: Document shows your text ("Test document...") + an embedded object icon/box (may appear as blank or "Package").

- **On Patched Office** (or with registry kill bit applied):
  - OLE object is blocked: "This object cannot be created" or similar warning.
  - Document opens but embedded content fails to load (gray box or error placeholder).

### Quick Summary Table

| Step                  | What You See (Success)                          | What It Means                          |
|-----------------------|-------------------------------------------------|----------------------------------------|
| Script Run            | "Generated malicious DOCX: test.docx"           | File created successfully              |
| OLE Bin Saved         | "embedded_ole.bin" file appears                 | OLE stream ready for embedding         |
| Open in Vulnerable Office | No block/prompt; OLE loads or icon shows       | Bypass worked (security decision skipped) |
| Open in Patched Office | Warning/block message or gray placeholder      | Patch/registry fix is effective        |

**Pro Tips**:

- Test in a **Windows VM snapshot** (disable Defender temporarily for research).
- Enhance: Use `oletools` to inspect the DOCX (`olevba test.docx` or `rtfobj`) and add real malicious OLE data.
- If no OLE loads: CLSID might be invalid—replace with a known unsafe one from `OleViewDotNet.exe` (free tool).

Patch Office immediately if affected! If you run it and get specific output/errors, paste them here for debugging. 😈

-----------------------------------

## 🛠️ Fix & Mitigation

### ✅ Patch Status

* Microsoft released **emergency out-of-band updates** in January 2026.
* Microsoft 365 users typically just need to **restart Office**.
* Office 2016/2019 users must **install the update manually**.

### 🔒 Temporary Protection (if unpatched)

* Registry-based mitigations are available to block malicious behavior until patching.

---

### ⚠️ **Disclaimer:** 

This information is provided for awareness and defensive security purposes only. No liability is assumed for misuse or inaccuracies.
