# 🚨 CVE-2026-21440 — Critical Security Vulnerability

<img width="1199" height="457" alt="G94XX20WIAAuE0T" src="https://github.com/user-attachments/assets/a24ff9c4-554c-4cf4-8c6b-baa5d6086192" />

### 🧩 Summary

**CVE-2026-21440** is a **critical path traversal vulnerability** affecting the **AdonisJS** framework, specifically its multipart file upload handling.

> ⚠️ If exploited, attackers can write files **anywhere on the server**, potentially leading to **remote code execution (RCE)**.

---

## 🏷️ Key Details

| Field                       | Value                   |
| --------------------------- | ----------------------- |
| **CVE ID**                  | CVE-2026-21440          |
| **Severity**                | 🔴 **Critical**         |
| **CVSS v4.0**               | **9.2**                 |
| **CWE**                     | CWE-22 (Path Traversal) |
| **Attack Vector**           | Network                 |
| **Authentication Required** | ❌ No                    |

---

## 🔍 What’s the Issue?

AdonisJS improperly trusts **user-supplied filenames** during multipart file uploads.

When developers call:

```js
MultipartFile.move()
```

without strict sanitization, attackers can submit filenames like:

```
../../../../app/config/startup.js
```

This allows them to **escape the intended upload directory** and write files to arbitrary locations on the server.

---

## 💥 Impact

An attacker can potentially:

* 📂 **Write arbitrary files** anywhere the server process has permission
* 🧨 **Overwrite application files or configs**
* 🖥️ Achieve **Remote Code Execution (RCE)**
* 🌐 Exploit the issue **remotely**, without authentication

This makes the vulnerability especially dangerous for **public file upload endpoints**.

---

## 📦 Affected Versions

### ❌ Vulnerable

* `@adonisjs/bodyparser` **≤ 10.1.1**
* `11.x` prereleases **before 11.0.0-next.6**

### ✅ Fixed

* **10.1.2**
* **11.0.0-next.6**

---

## 🛠️ Remediation (Strongly Recommended)

### 🔐 Immediate Fix

➡️ **Upgrade** to a patched version **as soon as possible**.

### 🧯 Temporary Mitigations

If upgrading isn’t possible yet:

* 🧼 Sanitize filenames (reject `../`, absolute paths, null bytes)
* 🧩 Use safe options in `MultipartFile.move()`
* 🔒 Require authentication for upload endpoints
* 📁 Restrict filesystem write permissions
* 🧱 Use a WAF to detect path traversal attempts

---

## 🕒 Disclosure Timeline

* 📅 **January 2, 2026** — GitHub Security Advisory published
* 📅 **January 2, 2026** — NVD entry released

---

## 📁 Short Steps to Use the CVE-2026-21440 PoC Script

1. **Install dependency**  
   `pip install requests`

2. **Save script**  
   Copy the full Python code and save as `cve_2026_21440_poc.py`

3. **Find upload endpoint**  
   Identify the target's multipart file upload URL (e.g., `/upload`, `/api/files`). Test with browser or curl.

4. **Run safe test first**  
   `python3 cve_2026_21440_poc.py http://target:port/upload --safe --random`

5. **Check success**  
   - Terminal: Look for "SUCCESS: File likely written!" and suggested URL.  
   - Browser: Open the suggested URL – if you see the PoC text, it's vulnerable.

6. **If vulnerable, try shell (optional)**  
   `python3 cve_2026_21440_poc.py http://target:port/upload --shell php --depth 5`

7. **Verify shell**  
   Access uploaded file (e.g., `http://target/shell.php?cmd=whoami`) for command output.

Use only on authorized targets! Start with `--safe`.

<img width="684" height="248" alt="cve-2026-21440" src="https://github.com/user-attachments/assets/fb3a553e-c63f-4e8f-b066-7b93d4a22fd1" />

---

```
╔══════════════════════════════════════════════════════════════╗
║                       ⚠️  DISCLAIMER  ⚠️                    ║
╚══════════════════════════════════════════════════════════════╝
```
This CVE-2026-21440 Proof-of-Concept script is provided 
SOLELY for educational, research, and authorized security testing purposes.

❌ You MAY use it on:
   • Systems you own
   • Systems you have explicit written permission to test

❌ You MAY NOT use it for:
   • Unauthorized access to any system
   • Illegal activities of any kind
   • Malicious purposes

The author and distributor assume NO liability for:
   • Misuse of this tool
   • Damage caused to systems
   • Legal consequences from unauthorized use

Using this script against systems without permission 
violates laws in most countries (e.g., CFAA in the US, 
Computer Misuse Act in the UK).

By using this tool, you agree to:
   • Take full responsibility for your actions
   • Comply with all applicable laws

Stay ethical. Test responsibly. 
Report vulnerabilities to vendors.

✦ Hack the planet — but legally ✦
