# CVE-2026-21436

Solus OS paket yöneticisi olan **eopkg <= 4.3.4**, `.eopkg` uzantılı paketlerin kurulumu sırasında paket içeriğinde absolute path barındıran dosyaları doğrudan belirtilen dizine yazıyor.

Paketi belirli bir dizine kurmak amacıyla kullanılan `--destdir` parametresi kullanılsa bile, paket içerisindeki `../` (traversal) karakterleri sayesinde bu kısıtlama atlatılabiliyor ve saldırgan tarafından hazırlanan dosyalar sistemdeki herhangi bir dizine yazdırılabiliyor. eopkg aracının paket kurulumu sırasında root yetkileriyle çalışması sebebiyle, sistemdeki mevcut dosyaların üzerine yazılması da mümkün.

Zafiyetin oluşma sebebi; `eopkg`'nin paketleri çıkartırken python'ın `.extract()` metodu ile `filter` parametresini kullanmaması veya herhangi bir şekilde dosya yollarını doğrulamamasıdır.

## POC

```
$ git clone https://github.com/osmancanvural/CVE-2026-21436/
$ cd CVE-2026-21436
```

1. Değiştirmek istediğiniz `.eopkg` uzantılı dosyayı indirin.
2. İçindeki `install.tar.xz` arşivinin içeriğini `tarcontent` klasörüne çıkartın.
3. Kötü amaçlı arşivi oluşturmak için script'i çalıştırın:

```
$ python3 archiveCreator.py
```

4. Oluşan `malicious-install.tar.xz` dosyasının adını `install.tar.xz` olarak değiştirin ve orijinal paket içerisindeki dosya ile yer değiştirin.
5. Paket Solus OS üzerinde kurulduğunda, `/tmp/hello.txt` dosyasının oluştuğunu görebilirsiniz.

**Not:** Hedef dizini ve dosya içeriğini değiştirmek için `archiveCreator.py` dosyasını ve `tarcontent` klasörünü düzenleyebilirsiniz.
