# CVE-2026-20805 PoC

Prueba de concepto para la vulnerabilidad de divulgación de información en **Desktop Windows Manager (dwm.exe)** de Microsoft.

## 📋 Resumen de la Vulnerabilidad

- **ID:** CVE-2026-20805
- **Producto:** Microsoft Windows
- **Componente:** Desktop Windows Manager (dwm.exe)
- **CWE-ID:** CWE-200 (Exposure of Sensitive Information to an Unauthorized Actor)
- **Severidad (CVSS 3.1):** 5.5 (Media)
- **Vector:** `CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:H/I:N/A:N`

Un atacante local ya autenticado puede explotar esta vulnerabilidad para revelar una dirección de sección de un puerto ALPC (Asynchronous Local Procedure Call) remoto, lo que constituye una fuga de memoria del modo usuario.

## 🚨 Impacto

La explotación exitosa permite a un atacante con bajos privilegios obtener información sensible de la memoria de otros procesos, lo que podría ser utilizado como parte de un ataque de mayor escala para evadir defensas o ganar mayor privilegio.

## 📂 Estructura del Repositorio
CVE-2026-20805-POC/
├── poc/ # Contiene la herramienta de observación
│ └── dumper.py # Script para monitorear la fuga de información
├── docs/ # Análisis técnico y referencias
│ └── technical_analysis.md
├── scripts/ # Scripts de automatización
│ └── setup_env.ps1 # Script de PowerShell para preparar el entorno
├── .gitignore
└── README.md
## ⚙️ Cómo Reproducir la Observación 
1. **Clona este repositorio:** ```bash git clone https://github.com/tu-usuario/CVE-2026-20805-POC.git cd CVE-2026-20805-POC ``` 
2. **Prepara el entorno (Opcional):** Ejecuta el script de PowerShell para asegurarte de tener las herramientas necesarias. ```powershell .\scripts\setup_env.ps1 ``` 
3. **Ejecuta la herramienta de monitoreo:** Ejecuta el script Python para monitorear los procesos y capturar la fuga de datos. ```bash python poc/dumper.py ``` 
4. **Observa la salida:** El script mostrará información de memoria que podría ser filtrada por `dwm.exe` bajo ciertas condiciones. Consulta `docs/technical_analysis.md` para interpretar los resultados. ## 🛡️ Mitigación Aplica las actualizaciones de seguridad más recientes de Microsoft según la guía publicada. Consulte el boletín de seguridad de Microsoft para obtener los parches correspondientes. ## 📄 Referencias - [Microsoft Security Update Guide](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2026-20805) - [CISA Known Exploited Vulnerabilities Catalog](https://www.cisa.gov/known-exploited-vulnerabilities-catalog?field_cve=CVE-2026-20805) - [NVD - CVE-2026-20805](https://nvd.nist.gov/vuln/detail/CVE-2026-20805) ## ⚠️ Advertencia Este repositorio es únicamente con fines educativos y de investigación. El autor no se hace responsable del mal uso de la información aquí presentada. Utiliza esta herramienta de manera responsable y únicamente en sistemas donde tengas permiso explícito. ## 📜 Licencia MIT License
