# CVE-2026-1107 Nuclei Template

Nuclei template for detecting **CVE-2026-1107** in EyouCMS.
The vulnerability allows unauthenticated attackers to perform Path Traversal/Arbitrary File Read via the `check_userinfo` function in `Diyajax.php`.

## Vulnerability Details

- **CVE ID:** CVE-2026-1107
- **Target:** EyouCMS < 1.7.1
- **Component:** Member Avatar Handler (`Diyajax.php`)
- **Impact:** Critical (Arbitrary File Read / Potential RCE)
- **Vector:** `POST /index.php?m=api&c=Diyajax&a=check_userinfo` (Parameter: `viewfile`)

## Logic

This template uses a **High-Fidelity** detection method. Instead of guessing configuration files (which may vary by OS or installation), it attempts to read the source code of the root `index.php` file using the traversal payload `../../index.php`.

If the server responds with raw PHP tags (`<?php`, `define('APP_PATH'`), the target is confirmed vulnerable.

## Usage

```bash
nuclei -t CVE-2026-1107.yaml -u [https://target.com](https://target.com)

```

## Exploit

https://github.com/24-2021/vul3/blob/main/Eyoucms/Eyoucms%3D1.7.1%20check_userinfo%20api%20viewfile%20exists%2C%20causing%20code%20execution%20due%20to%20file%20inclusion.md
