# CVE-2026-1056-POC
# Snow Monkey Forms - Unauthenticated Arbitrary File Deletion PoC

This repository contains a Proof of Concept (PoC) for a critical vulnerability in the **Snow Monkey Forms** WordPress plugin (versions <= 12.0.3). The vulnerability allows an **unauthenticated attacker** to delete arbitrary files on the server via Path Traversal.

**Refer:** [Sarawut Poolkhet (MisterHelloz)](https://www.wordfence.com/threat-intel/vulnerabilities/wordpress-plugins/snow-monkey-forms/snow-monkey-forms-1203-unauthenticated-arbitrary-file-deletion-via-path-traversal)

## Vulnerability Details

- **Type:** Arbitrary File Deletion / Path Traversal
- **Component:** `Snow_Monkey\Plugin\Forms\App\Rest\Route\View.php`
- **Method:** REST API (`/wp-json/snow-monkey-form/v1/view`)
- **Authentication:** Unauthencation

## Vulnerability Analysis

### 1. Entry Point & Logic Bypass
The vulnerability resides in the REST API handler located at `Snow_Monkey\Plugin\Forms\App\Rest\Route\View.php`. The `send()` method dictates the flow based on user input parameters.

```php
// File: App/Rest/Route/View.php

public function send() {
    Csrf::save_token();
    $method = Meta::get_method(); // Sourced from $_POST['snow-monkey-forms-meta']['method']

    // VULNERABILITY: If 'method' is 'input', the critical CSRF check is BYPASSED.
    if ( 'input' === $method ) {
        return $this->_send(); // Direct execution flow to _send()
    }

    // CSRF check is only performed for other methods (e.g., 'confirm', 'complete')
    if ( ! Csrf::validate( Meta::get_token() ) ) { ... }
```

By supplying `input` as the method parameter, an attacker forces the application to execute the `_send()` function immediately, skipping the `Csrf::validate()` security control intended to prevent unauthorized actions.

### 2. Path Traversal Injection
Inside the `_send()` method, the application attempts to perform a cleanup routine for user-specific temporary directories. This routine relies on the `formid` parameter.

```php
// File: App/Rest/Route/View.php -> _send()

// 'form_id' is sourced directly from POST data via Meta class without sanitization
$user_dirpath = Directory::generate_user_dirpath( $this->setting->get( 'form_id' ), false );

Directory::do_empty( $user_dirpath, true ); // Recursively delete contents
Directory::remove( $user_dirpath );         // Delete the directory itself
```

The critical flaw lies in how `Directory::generate_user_dirpath` constructs the path:

```php
// File: App/Model/Directory.php

public static function generate_user_dirpath( $form_id, $do_create_directory = true ) {
    $saved_token = Csrf::saved_token();
    // ... (Regex check for token exists, but not for form_id) ...

    $user_dir = path_join( static::get(), $saved_token );
    
    // VULNERABILITY: $form_id is appended directly. 
    // WordPress path_join() does NOT resolve or sanitize '../' sequences.
    $user_dir = path_join( $user_dir, (string) $form_id ); 

    return $user_dir;
}
```

The `$form_id` variable is cast to a string but is **never validated to be an integer**. This allows an attacker to inject directory traversal characters (e.g., `../../../../`).

## Usage
- **Find version** http://site-wordpress.com/wp-content/plugins/snow-monkey-forms/readme.txt
### Prerequisites
- Python 3.x
- `requests` library (`pip install requests`)

### Command

```bash
python exploit.py -u <TARGET_URL> -f <TRAVERSAL_PAYLOAD>
```
<img width="1545" height="537" alt="CVE-2026-1056-POC" src="https://github.com/user-attachments/assets/ac2d9eb8-5874-4fca-9c7b-e263856fedb4" />
