# CVE-2026-0920 PoC: LA-Studio Element Kit Backdoor Exploit

A robust Proof of Concept (PoC) exploit written in Go for the critical backdoor vulnerability found in **LA-Studio Element Kit for Elementor** plugin (versions <= 1.5.6.3).

This tool demonstrates how an unauthenticated attacker can leverage the `lakit_ajax` wrapper to bypass security checks and inject a malicious payload, resulting in the creation of an **Administrator** account.

## 🚨 Vulnerability Details
- **CVE:** CVE-2026-0920
- **Type:** Privilege Escalation / Authentication Bypass
- **Severity:** Critical (9.8/10)
- **Vector:** The plugin exposes an AJAX action (`lakit_ajax`) that processes JSON payloads. By manipulating the `lakit_bkrole` parameter within the registration data, the plugin executes a hidden backdoor function (`ajax_register_handle_backup`) to assign Administrator privileges to the new user.
- **Google Dork:** `inurl:"/wp-content/plugins/lastudio-element-kit"`

## Features
- **Auto-Discovery:** Automatically scrapes the target page to extract valid `_nonce` tokens and the correct `admin-ajax.php` URL.
- **Smart Logic:** Bypasses the plugin's username validation bug by forcing email-based user generation.
- **Cross-Platform:** Works on Windows, Linux, and macOS (with color-coded output adjustments).
- **Customizable:** Allows manual nonce input for targets with strict caching or WAFs.

## Proof of Concept
![Exploit Output Screenshot](https://raw.githubusercontent.com/Galaxy-sc/CVE-2026-0920-WordPress-LA-Studio-Exploit/refs/heads/main/CVE-2026-0920.PNG)

## Usage

### Run
Standard Mode (Auto-Discovery): Provide the URL of a page where the LA-Studio widgets (Login/Register) are present.

```bash
go run .\CVE-2026-0920.go -u http://target-site.com/register
```

### Custom Credentials:

```bash
go run .\CVE-2026-0920.go -u http://target-site.com/register -email myadmin@evil.com -pass SuperSecret123!
```

Manual Mode (If auto-discovery fails): Get the `ajaxNonce` and `lakit-register-nonce` from the page source and provide them manually:

```bash
go run .\CVE-2026-0920.go -u http://target-site.com/register -nonce "NONCE_VALUE" -rnonce "REGISTER_NONCE_VALUE"
```

### ⚠️ Legal Disclaimer
This tool is intended for educational purposes and security research only.

The author is not responsible for any illegal use of this tool. Use this exploit only on systems you own or have explicit permission to test. Analyzing and exploiting vulnerabilities on unauthorized systems is illegal and punishable by law.

### License
This project is licensed under the MIT License.
