# CVE-2026-0834 (PoC)
TP-Link Device Debug Protocol (TDDP) Authentication Bypass (CVE-2026-0834)

## Overview
A vulnerability in the TDDP (TP-Link Device Debug Protocol) service allows unauthenticated remote attackers on the local network to execute administrative commands. When processing TDDPv2 packets, a `pktLength` value of `0` causes the DES decryption routine to be skipped due to short-circuit evaluation. Data sent beyond the 28-byte packet header is placed in the buffer where decrypted payload data is expected, bypassing authentication and allowing it to be interpreted as valid command data.

Attackers can exploit this to execute administrative functions including factory reset and device reboot without credentials.

This vulnerability affects the TDDP service implementation. All firmware versions analysed were found to exhibit the vulnerable code pattern in `tddp_parserHandler()`. However, not all TP-Link devices have TDDP enabled by default.

This Proof of Concept (PoC) was created for the TP-Link Archer C20 V6 (firmware 0.9.1 Build 4.19/4.20). Memory offsets, command structures, and exploitation techniques may differ on other device models or firmware versions.

## Warning
This PoC performs a factory reset and reboot on the target device. All configuration will be wiped.

## Usage
```bash
$ python3 cve-2026-0834.py

[*] Target: 192.168.0.1:1040
[*] Sending factory reset command (0x49)...
[+] Response from ('192.168.0.1', 1040): 020701000000001000010000f876a43eae343258cfd6e426a435156bc3813de141e9a2162714388fe3af8e0c
[*] Waiting 1 second...
[*] Sending reboot command (0x4A)...
[+] Response from ('192.168.0.1', 1040): 0207010000000010000100009b0361efe2560a92e1e6feba5bfe21cec3813de141e9a216660a7b69eca4e234
```

Edit the `TARGET_IP` within the script to match the IP address of the target device.

## Links
- Full Writeup: https://mattg.systems/posts/cve-2026-0834/
- CVE Record: https://www.cve.org/CVERecord?id=CVE-2026-0834
