# CVE-2026-0594-ListSiteContributors-Plugin-Exploit

## 🛡️ Description
**CVE-2026-0594** is a critical Reflected Cross-Site Scripting (XSS) vulnerability found in the **List Site Contributors** WordPress plugin. This exploit automates the discovery of vulnerable endpoints via the WordPress REST API (`wp-json`) and executes a specialized payload through the `alpha` parameter.

By leveraging this vulnerability, an attacker can:
* **Bypass Authentication** via HMAC forgery and session cookie theft.
* **Exfiltrate Sensitive Data** (PII) and system configuration.
* **Execute Arbitrary JavaScript** in the context of the victim's browser.

---

## 🚀 Features
- **Dynamic Slug Discovery**: Automatically fetches all site pages via WP-JSON.
- **Concurrent Scanning**: Uses Go Goroutines to test multiple slugs simultaneously.
- **Clean Output**: Displays only confirmed vulnerable targets in a professional format.
- **Automated Verification**: Double-checks the reflection of the payload before reporting.

---

## 🛠️ Installation & Requirements

1. **Requirement**: Install [Go](https://golang.org/dl/) (version 1.19 or higher).
2. **Clone/Download**: Save the `CVE-2026-0594.go` file on your system.

---

## 💻 Usage

To run the exploit, navigate to the project directory and use the following command:

```bash
go run CVE-2026-0594.go
```
![image](https://raw.githubusercontent.com/m4sh-wacker/CVE-2026-0594-ListSiteContributors-Plugin-Exploit/refs/heads/main/image.png)
