# Trinity-Audio-CVE-Report 2
Disclosure for CVE-2025-9886 and CVE-2025-9952.

# CVE-2025-9886 and CVE-2025-9952 - Vulnerability in Trinity Audio

This repository discloses a vulnerability discovered in [Trinity Audio <= 5.20.1](https://wordpress.org/plugins/trinity-audio/),WordPress plugin developed by sergiotrinity.

## 🛠 Affected Version

- **Product**: Trinity Audio
- **Version**: v5.20.1
- **URL**: https://wordpress.org/plugins/trinity-audio/

---

## 🔒 Assigned CVE
| CVE ID            | Type                      | Component                | Impact                    |
|-------------------|---------------------------|--------------------------|---------------------------|
| CVE-2025-9886    | Cross-Site Request Forgery                | admin/inc/post-management.php            | Bulk enable/disable of Trinity Audio on posts under the victim’s session     |  
| CVE-2025-9952    | Reflected Cross-Site Scripting             | admin/inc/post-management.php            | Arbitrary script execution     |  

---

## 🧾 Detailed a Description

### CVE-2025-9886 — Cross-Site Request Forgery

 - **Affected Component**: Post Management page handler (admin/inc/post-management.php)
   
 - **Attack Vector**: Cross-origin POST to wp-admin/admin.php?page=trinity_audio_post_management
   
 - **Trigger**: An authenticated admin visits an attacker-controlled page that auto-submits a crafted form
   
 - **Impact**: Attacker forces bulk state changes (enable/disable Trinity Audio on all posts or a date range) with the admin’s privileges, harming integrity and potentially availability

### CVE-2025-9952 — Cross-Site Scripting

 - **Affected Component**: Post Management page handler (admin/inc/post-management.php)
   
 - **Attack Vector**: Cross-origin POST to wp-admin/admin.php?page=trinity_audio_post_management with post-management-action=activate-all-posts-range, range-before-after=after, and a valid date followed by HTML.
   
 - **Trigger**: An authenticated admin visits an attacker-controlled page that auto-submits the crafted form. At least one post published after the supplied date must exist.
   
 - **Impact**: Arbitrary JavaScript executes in the admin’s origin, enabling session theft, settings manipulation, or CSRF chaining.
   
### PoC

　By combining these two vulnerabilities, an attacker can execute arbitrary scripts by directing users to a site containing the following form.
 
  1. The admin is logged in to the target site.
  2. The attacker hosts the following HTML:
```
<form method="POST" action="https://victim.example.com/wp-admin/admin.php?page=trinity_audio_post_management">
  <input type="hidden" name="action" value="1">
  <input type="hidden" name="post-management-action" value="activate-all-posts-range">
  <input type="hidden" name="range-before-after" value="after">
  <input type="hidden" name="range-date" value="2025-09-03&lt;img src=x onerror=alert(document.domain)&gt;">
</form>
<script>document.forms[0].submit();</script>
```

## ❓Reason for the vulnerability

 - **CSRF(CVE-2025-9886)**:
   The state-changing endpoint accepts cross-origin requests without CSRF defenses. There is no nonce verification (check_admin_referer/wp_verify_nonce) and no Origin/Referer validation. Because cookies are sent automatically, an attacker can cause actions to run under an authenticated user’s session.
   
 - **Reflected XSS(CVE-2025-9952)**:
   The Post Management handler (admin/inc/post-management.php) interpolates the range-date POST value into the success notice without output encoding (no esc_html()/wp_kses()), allowing HTML/JS injection.
 
 ### Proposed Fix:
 - Require a valid CSRF token on all state-changing requests: add wp_nonce_field(...) to forms and verify with check_admin_referer(...) or wp_verify_nonce(...).
 - The range-date parameter must be properly escaped before being rendered.

## ひとこと
一見ただのCSRFとSelfXSSだが、これらを組み合わせることでCSRFを成功させれば任意のJSを実行させることが出来る。
このような面白いPoCを作成することが出来て楽しかった。

## 🔍 Discoverer

**Name**: MooseLove  
**Role**: Independent security researcher / bug hunter  
**Contact**: Available upon request  

---

## 📚 References

- Product: https://wordpress.org/plugins/trinity-audio/

---

## ⚠️ License

This advisory is provided for public security awareness. Free to share with attribution.

