# ⚡️ Cloudflare Image Resizing <= 1.5.6 - Unauthenticated Remote Code Execution (CVE-2025-8723) Exploit

---

## 🚨 Vulnerability Overview

**Cloudflare Image Resizing** plugin for WordPress (versions <= 1.5.6) suffers from a _Missing Authentication_ vulnerability which allows **Unauthenticated Remote Code Execution (RCE)** via the `rest_pre_dispatch` hook.

- **CVE:** CVE-2025-8723  
- **CVSS Score:** 9.8 (Critical)  
- **Published:** August 18, 2025  
- **Vector:** `CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H`  
- **Discovered by:** Wordfence Intelligence

> **Description:**  
> The plugin's REST API endpoint fails to authenticate users and improperly sanitizes input in the `hook_rest_pre_dispatch()` method. This flaw enables attackers to inject and execute arbitrary PHP code by crafting malicious requests — with no login required.

---

## 🛠 Features of This Exploit

- **Professional, modular, and extensible Python script**
- **Automatic detection** of plugin vulnerability by parsing the `readme.txt` file
- **Multiple bypass techniques** for WAF and restrictive environments:
  - Minimal and advanced header sets (randomized User-Agent, Referer, Origin, X-Forwarded-For, etc.)
  - Repeated attempts with header rotation
  - Proxy support (custom or BurpSuite-style)
- **Custom command execution:**  
  - Default: `whoami`, but user can specify any command
- **Clear, professional output** with informative status codes
- **Handles all error cases gracefully** (missing plugin, forbidden/unauthorized, server errors, etc.)

---

## 📦 What’s Inside the Script?

### 1️⃣ **Automatic Vulnerability Detection**
- Fetches `wp-content/plugins/cf-image-resizing/readme.txt`
- Extracts and checks the plugin version
- If version ≤ 1.5.6, proceeds to exploitation

### 2️⃣ **Multiple Exploit Strategies**
- **Minimal headers**: Sends only what's necessary to maximize compatibility
- **Advanced headers**: Randomizes User-Agent, Referer, Origin, Accept-Language, and more for each attempt
- **Header rotation**: Tries several combinations to evade WAF and rate limiting

### 3️⃣ **Customizable Execution**
- Run any system command on the target via CLI argument  
  _Example: `-c "id"`_

### 4️⃣ **Proxy Support**
- Use `--proxy` to send requests through a proxy (e.g., BurpSuite)

### 5️⃣ **Comprehensive Output**
- Shows detected version, vulnerability status, attempted methods, and actual command output


---

## 🚀 Usage

```bash
python3 CVE-2025-8723.py -u http://target.com/
```
- **Default command:** `whoami`

Specify a custom command:
```bash
python3 CVE-2025-8723.py -u http://target.com/ -c "id"
```

Use a proxy (e.g., BurpSuite):
```bash
python3 CVE-2025-8723.py -u http://target.com/ --proxy http://127.0.0.1:8080
```

Increase advanced header attempts (default is 5):
```bash
python3 CVE-2025-8723.py -u http://target.com/ --attempts 10
```

---

## 🧩 Example Output

```
[+] CVE-2025-8723 Exploit | by Khaled Alenazi (Nxploited)
[+] Detected version: 1.5.6
[+] Target is vulnerable (<=1.5.6). Proceeding with exploit.
[*] Trying minimal headers (only Content-Type)...
[=] Minimal Headers | Status: 200
www-data
[+] Exploit worked with this method!
```

---

## 🛡️ Bypass & Evasion Techniques

- **Header Randomization:** Tries various User-Agent, Referer, Origin and Accept-Language combinations
- **Proxy Support:** Use a proxy to rotate IPs and bypass IP-based restrictions
- **Multiple Attempts:** Retries with new headers if requests are blocked or forbidden
- **Error Handling:** Smartly interprets all common responses (404, 401, 403, 5xx, timeouts)

---

## 📖 Script Structure Explained

- **normalize_url:** Ensures URL format correctness
- **get_headers:** Generates randomized advanced headers for each attempt
- **get_readme/extract_version/is_vulnerable:** Automated vulnerability detection logic
- **try_exploit:** Attempts exploitation with a given header set
- **exploit_all:** Orchestrates all exploit attempts, switching header strategies automatically
- **scan:** Checks for plugin presence and vulnerability
- **Nxploited (main):** Argument parsing, reporting, and exploit workflow

---

## ⚠️ Disclaimer

This tool is for authorized security testing and educational purposes only.  
The developer is not responsible for any misuse or damage caused by this code.

---

*By: Khaled Alenazi (Nxploited)*
