# CVE-2025-8714-POC
PoC de RCE en PostgreSQL — CVE-2025-8714
# PoC de Ejecución Remota de Código en PostgreSQL — CVE-2025-8714 (pg_dump Reverse Shell)

Este repositorio presenta una prueba de concepto (PoC) para la vulnerabilidad crítica **CVE-2025-8714** que afecta a versiones PostgreSQL anteriores a: 17.6, 16.10, 15.14, 14.19, 13.22, y 18 Beta ...

. La vulnerabilidad permite a un atacante con privilegios de superusuario en el servidor de origen inyectar comandos arbitrarios en un dump de base de datos generado con `pg_dump` o `pg_dumpall` en formato plano. Estos comandos se ejecutan con los permisos del usuario que restaura el dump usando `psql`, permitiendo la ejecución remota de código (RCE).

---

## Descripción técnica

La vulnerabilidad CVE-2025-8714 se encuentra en la forma en que PostgreSQL genera y procesa dumps en formato plano. Un usuario con permisos superusuario puede añadir meta-comandos que se ejecutan al restaurar el dump, lo que puede provocar ejecución arbitraria de comandos en el sistema operativo.

Este PoC demuestra cómo aprovechar esta vulnerabilidad en un entorno Docker con PostgreSQL 14.14 para obtener una shell reversa desde el contenedor víctima hacia el atacante.

---

## Contenido del repositorio

poc.sh # Script Bash con PoC automatizado y comentado
README.md # Documentación técnica, guía de uso y consideraciones éticas

---

## Requisitos

- Docker instalado y funcionando  
- Netcat (`nc`) para abrir el listener  
- Bash compatible (Linux/macOS)

---

## Uso

1. Clona el repositorio:
   ```bash
   git clone https://github.com/orderby99/CVE-2025-8714-POC.git
   cd CVE-2025-8714-POC

    Edita poc.sh y reemplaza ATTACKER_IP con la IP de tu máquina atacante (donde abrirás netcat).

    En tu máquina atacante, inicia un listener:

nc -lvnp 4444

Ejecuta el PoC:

chmod +x poc.sh
./poc.sh

recibiras una shell reversa desde el contenedor PostgreSQL víctima.

# Advertencias legales y éticas

# ⚠️ Este proyecto está diseñado exclusivamente para fines educativos, de investigación y concienciación en ciberseguridad.
El uso sin autorización en sistemas que no te pertenezcan es ilegal y antiético.

Mitigaciones recomendadas

Actualiza a las versiones parcheadas: PostgreSQL 17.6, 16.10, 15.14, 14.19, 13.22 o superiores.

Evita restaurar dumps en formato plano de fuentes no confiables.

Usa formatos de dump seguros (custom o directory).

Inspecciona dumps antes de restaurar.

# Licencia

MIT License — uso libre para educación e investigación.

Autor: orderby99
Repositorio dedicado a compartir conocimientos prácticos para comprender como funcionan y como protegerse de las nuevas vulnerabiliades.
