# CVE-2025-8570
BeyondCart Connector &lt;= 2.1.0 - Missing Configuration of JWT Secret to Unauthenticated Privilege Escalation


# 🚨 BeyondCart Connector <= 2.1.0 - JWT Privilege Escalation (CVE-2025-8570)

## 🛡️ Vulnerability Overview

The **BeyondCart Connector** plugin for WordPress, in versions **1.4.2 through 2.1.0**, is vulnerable to **Privilege Escalation** due to improper JWT secret management and faulty authorization mechanisms within the `determine_current_user` filter.  
This vulnerability allows unauthenticated attackers to craft valid JSON Web Tokens (JWT) and impersonate any user, including administrators, potentially leading to a full site compromise.

- **CVE:** CVE-2025-8570  
- **CVSS Score:** 9.8 (Critical)  
- **Public Disclosure:** September 10, 2025

---

## ⚙️ Script Purpose

This repository provides an automated exploit script that leverages the misconfigured JWT secret to escalate privileges and update administrative user data on vulnerable WordPress installations using the BeyondCart Connector plugin.

---

## 🚀 Usage Instructions

1. **Prerequisites:**  
   - Python 3.x  
   - Required Python libraries: `requests`, `pyjwt`  
   - Target site must be running BeyondCart Connector plugin version **1.4.2 to 2.1.0**
2. **How to Use:**  
   - Run the script with the required arguments from your terminal.
   

---

## 📝 Arguments & Parameters

- **`--url`** (required): Target WordPress site URL (e.g., `http://target.site`)
- **`--email`**: New email for the admin user (default: `nxploitadmin@example.com`)
- **`--first_name`**: New first name for the admin user (default: `Nxploited`)
- **`--last_name`**: New last name for the admin user (default: `Nxploited`)
- **`--username`**: Username to impersonate (default: `superadmin`)
- **`--password`**: New password for the user (optional)
- **`--id`**: User ID to escalate to (default: `1`, which is typically the admin)
- **`--token`**: Custom JWT token (optional)
- **`--output`**: Write output to a file (optional)

---

## 🕹️ Post-Exploitation

After updating the administrator account credentials with this script, you can utilize the **"Forgot Password"** feature on the WordPress login page.  
By entering the newly set email, you can reset and regain full access to the administrator account via the official dashboard.

---

## ✅ Expected Output

Upon successful exploitation, the script will display a response similar to:

```json
HTTP/1.1 200 OK
...
{
  "id": 1,
  "email": "nxploitadmin@example.com",
  "first_name": "Nxploited",
  "last_name": "Nxploited",
  "role": "administrator",
  "username": "superadmin"
}
```

---

## ⚠️ Disclaimer

This tool is provided for **educational and authorized security testing purposes only**.  
Any misuse of this tool for unauthorized access or malicious activity is strictly prohibited.  
The author assumes **no responsibility** for any damage caused by the use or misuse of this tool.

---

**_By: Nxploited (Khaled Alenazi)_**
