# Prerequisites
Docker
Docker Compose
wget and a standard command-line interface (bash, zsh, etc.)

# 1. Environment Setup & Deployment
These steps will download the vulnerable version of Vvveb CMS and configure a Docker environment to run it.

## Step 1.1: Download Vvveb CMS
```
# Create and navigate to the project directory
mkdir Vvveb-RCE-PoC
cd Vvveb-RCE-PoC

# Download the vulnerable version of Vvveb CMS
wget https://github.com/givanz/Vvveb/releases/download/1.0.5/latest.zip

# Unzip the application files (you will need 'unzip' installed)
# On Debian/Ubuntu: sudo apt-get install unzip
unzip latest.zip
```

## Step 1.2: Configure the Docker Environment
The default Docker setup requires a few modifications to work correctly and build efficiently.

### A. Create a .dockerignore file
This file prevents unnecessary files from being copied into the Docker image, speeding up the build process.
```
cat > .dockerignore << EOL
# Ignore version control files
.git/
.gitignore

# Ignore the large zip file
latest.zip

# Ignore Docker specific files
docker-compose.yaml
Dockerfile

# Ignore local environment and editor files
.env
.vscode/
EOL
```

### B. Modify the Dockerfile

We need to add the 'libicu-dev' package, which is a dependency for the intl PHP extension required by the application.

Find the RUN `apt-get install -y` block in the Dockerfile and add 'libicu-dev \' to the list.

Your modified 'Dockerfile' should look like this:
```
FROM php:8.3-fpm

RUN apt-get clean && apt-get update

RUN apt-get install -y \
  libicu-dev \
  libfreetype6-dev \
  libjpeg62-turbo-dev \
  libxml2-dev \
  libwebp-dev \
  libpng-dev \
  libzip-dev \
  libonig-dev \
  libcurl4-openssl-dev \
  && docker-php-ext-configure gd  --with-webp --with-jpeg\
  && docker-php-ext-install -j$(nproc) gd\
  && docker-php-ext-install xml dom curl mbstring intl gettext\
  && docker-php-ext-install zip\
  && pecl bundle -d /usr/src/php/ext apcu\
  && docker-php-ext-install /usr/src/php/ext/apcu\
# && docker-php-ext-install sqlite3\
  && docker-php-ext-install mysqli

COPY php.ini ${PHP_INI_DIR}
```

### C. Fix Nginx Configuration (502 Bad Gateway)
The default Nginx configuration may not correctly route PHP requests to the PHP-FPM container. We need to ensure the fastcgi_pass directive points to the correct service name (php:9000).
1. Open the Nginx configuration file: nano nginx-docker.conf
2. Locate the location ~ \.php$ block.
3. Ensure the fastcgi_pass line is set to php:9000;.

The corrected block should look like this:
```
# ... other nginx config ...

    location ~ \.php$ {
        try_files $uri =404;
        fastcgi_split_path_info ^(.+\.php)(/.+)$;

        # THIS IS THE CRITICAL LINE
        fastcgi_pass   php:9000;

        fastcgi_index  index.php;
        include        fastcgi_params;
        fastcgi_param  SCRIPT_FILENAME $document_root$fastcgi_script_name;
        fastcgi_param  PATH_INFO $fastcgi_path_info;
    }

# ... other nginx config ...
```

## Step 1.3: Launch the Application
Now, build and run the Docker containers.
```
# Build the images and start the containers in detached mode
sudo docker-compose up -d --build
```

Access the application in your browser, typically at http://localhost:8080. Follow the on-screen installation steps. The default database host should be mysql. Use root for the user and the password you set in docker-compose.yaml.
