# CVE-2025-8088
Python tool for safe archive handling, path traversal awareness, and secure extraction. Inspired by CVE-2025-8088.



Safe Archive Handling PoC

Educational blue-team tool inspired by path traversal issues such as CVE-2025-8088.
This script helps detect and safely handle dangerous archive entries without creating or deploying any malicious payloads.

Features

	•	Harmless ZIP traversal simulation — build ZIP files that store a benign file under a traversal path (for training/testing).
 
	•	Archive auditing — scan ZIP and RAR files for suspicious paths before extraction.
 
	•	Safe extraction — extract only trusted entries, blocking potential traversal or absolute-path exploits.

Why This Matters

Path traversal in archive files can allow attackers to drop files outside the intended extraction folder, sometimes into sensitive locations such as startup folders or system directories.
This project demonstrates the concept safely and provides defensive tools to handle untrusted archives.

Installation

Requires Python 3.7+

||| pip install rarfile

For RAR auditing, you must also install an UnRAR backend on your OS.



Usage

1. Build a harmless ZIP with a traversal path

   python CVE-2025-8088.py -p "C:\Windows\System32\calc.exe" -o "C:\lab\malicious_calc.rar"

   ⚠️ Only open the generated ZIP in a safe test environment.

   
python safe_traversal_poc.py audit suspicious.rar

2. Audit an archive

   python safe_extract.py audit suspicious.rar

3. Safe extraction

python safe_traversal_poc.py extract-safe suspicious.zip safe_output

python safe_traversal_poc.py extract-safe suspicious.zip safe_output


[OK] docs/readme.txt
[!!] ../../AppData/Roaming/Microsoft/Windows/Start Menu/Programs/Startup/file.exe
[SKIP] dangerous path in ZIP: ../../AppData/Roaming/Microsoft/Windows/Start Menu/Programs/Startup/file.exe


Safety Notes

	•	This project does not create malicious files or weaponized RAR exploits.
 
	•	The traversal PoC uses only benign files you provide (e.g., calc.exe).
 
	•	Always test in an isolated lab environment.

