# CVE-2025-7771 – ThrottleStop.sys Privilege Escalation

## Vulnerability Details
- **CVE ID**: CVE-2025-7771  
- **Component**: `ThrottleStop.sys` (legitimate driver)  
- **Affected Versions**: ThrottleStop 3.0.0.0 (and possibly others)  
- **Vulnerability Type**: Exposed IOCTL with Insufficient Access Control (CWE-782)  
- **Impact**: Local Privilege Escalation (LPE)  
- **CVSS Score**: 8.7 (High) – [Kaspersky Labs Assessment]  

### Description
The `ThrottleStop.sys` driver exposes two insecure IOCTL interfaces that allow arbitrary read and write access to physical memory via the `MmMapIoSpace` function.  
A malicious local user-mode application can abuse these IOCTLs to patch the running Windows kernel and invoke arbitrary kernel functions with **ring-0 privileges**.  
This enables privilege escalation and potential follow-on attacks such as:
- Disabling or tampering with security software  
- Bypassing kernel-level protections (e.g., PatchGuard, Driver Signature Enforcement)  
- Arbitrary code execution in kernel context  

---

## Exploit Concept
The exploit leverages `DeviceIoControl` calls against `ThrottleStop.sys` to:  
1. **Open Handle** → Gain access to `\\Device\\ThrottleStop` driver object.  
2. **Arbitrary Read/Write** → Use vulnerable IOCTLs to map kernel memory into user space.  
3. **Kernel Patch** → Modify kernel structures or function pointers.  
4. **Privilege Escalation** → Redirect execution to attacker-controlled shellcode.  

---

## Compilation & Usage
```bash
# Compile (example with MSVC)
cl exploit.c /DUNICODE /D_UNICODE /Wall /nologo /Fe:exploit.exe

# Run (must be executed locally on vulnerable system)
exploit.exe
```
>⚠️ Note: Proof-of-Concept (PoC) code should only be executed in controlled test environments such as a VM. Running it on production systems is dangerous.
```
+--------------------+
| User-mode process  |
+---------+----------+
          |
          v
+--------------------+        IOCTL Calls        +---------------------+
|  ThrottleStop.sys  | <-----------------------> | MmMapIoSpace Kernel |
|  (Insecure driver) |                          |  Arbitrary R/W      |
+---------+----------+                          +----------+----------+
          |                                                |
          v                                                v
   Arbitrary Kernel Patch ----------------------> Kernel Privilege Escalation
```
## Tested Platforms

- Windows 10 Pro x64 (build 19045) – vulnerable

- Windows 11 Pro x64 (build 22631) – vulnerable

- Other versions using ThrottleStop.sys 3.0.0.0 may also be affected.

## Recommendations

- ## Immediate Mitigation : Remove or disable the vulnerable ThrottleStop.sys driver if not required.

- ## Vendor Patch  : Apply updates from TechPowerUp once available.

- ## System Hardening: 

- Run with least privilege accounts where possible

- Monitor and block unsigned/unverified drivers

- Enable Kernel-mode Code Integrity (KMCI) enforcement



## Disclaimer

>This repository and documentation are provided for educational and defensive research purposes only.
Any use of the PoC to compromise systems without explicit authorization is illegal.

>The authors and contributors are not responsible for misuse or damage caused by this material.
