cd ~
sudo apt-get update
sudo apt install -y build-essential texinfo bison flex libgmp-dev libmpfr-dev libmpc-dev gdb git gcc g++ make python3-pip python3.11-venv xxd
git clone https://github.com/bminor/binutils-gdb
cd binutils-gdb
git checkout 08c3cbe5926e4d355b5cb70bbec2b1eeb40c2944^1
mkdir build
cd build
unset CFLAGS
unset CXXFLAGS
unset CC
unset CXX
unset LDFLAGS
export CC=gcc
export CXX=g++
export CFLAGS="-g -O0 -fsanitize=address -fno-omit-frame-pointer"
export CXXFLAGS="-g -O0 -fsanitize=address -fno-omit-frame-pointer"
export LDFLAGS="-fsanitize=address"
echo "CC=$CC"
echo "CXX=$CXX"
echo "CFLAGS=$CFLAGS"
echo "CXXFLAGS=$CXXFLAGS"
echo "LDFLAGS=$LDFLAGS"
$CC --version
$CXX --version
../configure \
  --disable-shared \
  --disable-gdb \
  --disable-gdbserver \
  --disable-gdbsupport \
  --disable-gnulib \
  --disable-libdecnumber \
  --disable-gas \
  --disable-ld \
  --disable-gold \
  --disable-sim \
  --disable-gprof \
  --disable-gprofng
make -j$(nproc)
./binutils/objcopy --version
mkdir -p ~/iot_router_project/firmware_samples
mkdir -p ~/iot_router_project/tools
mkdir -p ~/iot_router_project/bootloader_sections
mkdir -p /tmp/firmware_work
cd ~/iot_router_project
echo "[+] Структура проекта создана"
cd ~/iot_router_project/firmware_samples
dd if=/dev/urandom of=bootloader.bin bs=1024 count=8 2>/dev/null
dd if=/dev/urandom of=kernel_config.bin bs=1024 count=8 2>/dev/null
dd if=/dev/urandom of=root_filesystem.bin bs=1024 count=8 2>/dev/null
dd if=/dev/zero of=device_calibration_data.bin bs=1 count=1 2>/dev/null
ls -lh
cd ~/iot_router_project/tools

cat > process_firmware.sh << 'SCRIPTEOF'
#!/bin/bash

OBJCOPY="${1:-./../binutils-gdb/build/binutils/objcopy}"
FIRMWARE_DIR="./firmware_samples"
OUTPUT_DIR="/tmp/firmware_work"

# Создаём директорию для выходных файлов
mkdir -p "$OUTPUT_DIR"

if [ ! -f "$OBJCOPY" ]; then
    echo "[-] Ошибка: objcopy не найден по пути: $OBJCOPY"
    exit 1
fi

echo "  IoT Router Firmware Processing Tool"
echo ""
echo "[*] objcopy: $OBJCOPY"
echo "[*] Firmware directory: $FIRMWARE_DIR"
echo "[*] Output directory: $OUTPUT_DIR"
echo ""

# Процессируем все firmware-файлы
for fw_file in $FIRMWARE_DIR/*.bin; do
    if [ ! -f "$fw_file" ]; then
        continue
    fi

    filename=$(basename "$fw_file" .bin)
    filesize=$(stat -f%z "$fw_file" 2>/dev/null || stat -c%s "$fw_file")
    output_file="$OUTPUT_DIR/${filename}_converted.o"
    log_file="/tmp/objcopy_${filename}.log"

    echo ""
    echo "Processing: $filename"
    echo ""
    echo "[*] Input file: $fw_file"
    echo "[*] File size: $filesize bytes"
    echo "[*] Output file: $output_file"
    echo ""

    ASAN_OPTIONS="halt_on_error=1:abort_on_error=1:verbosity=1" \
    "$OBJCOPY" \
        -I binary \
        -O elf64-x86-64 \
        --output-target=elf64-x86-64 \
        --byte=0 \
        --interleave=4 \
        --interleave-width=2 \
        --remove-section=.debug_info \
        -S "$fw_file" "$output_file" &> "$log_file"

    status=$?


    if grep -q "ERROR: AddressSanitizer.*heap-buffer-overflow" "$log_file" 2>/dev/null; then

        # Извлекаем тип ошибки
        error_line=$(grep "ERROR: AddressSanitizer" "$log_file" | head -1)
        echo "$error_line" | sed 's/^/ /'

        # Показываем детали доступа
        if grep -q "READ of size\|WRITE of size" "$log_file"; then
            access_line=$(grep "READ of size\|WRITE of size" "$log_file" | head -1)
            echo "$access_line" | sed 's/^/ /'
        fi
        echo ""

    else
        # Файл обработан успешно
        if [ $status -eq 0 ]; then
            output_size=$(stat -f%z "$output_file" 2>/dev/null || stat -c%s "$output_file")
            echo "[+] ✓ Conversion successful"
            echo "[+] Output size: $output_size bytes"
        else
            echo "[!] Warning: Process exited with code $status"

            # Проверяем лог на ошибки
            if grep -q "ERROR" "$log_file"; then
                echo "[!] Errors found in log"
            fi
        fi
    fi

    echo ""
done

echo ""
echo "  Processing Complete"
echo ""
echo "[*] Converted files location: $OUTPUT_DIR"
ls -lh "$OUTPUT_DIR"/*.o 2>/dev/null || echo "No output files generated"

echo ""
SCRIPTEOF

chmod +x process_firmware.sh

echo "[+] process_firmware.sh создан"
mkdir -p ~/engineer_tools
cd ~/engineer_tools

echo "[+] Директория инженера создана"
cd ~/engineer_tools

cat > firmware-extractor << 'SCRIPT1EOF'
#!/bin/bash

# firmware-extractor - обычная утилита для распаковки firmware
# Просто вызывает objcopy без каких-либо специальных действий

OBJCOPY="/home/student/binutils-gdb/build/binutils/objcopy"

if [ $# -lt 2 ]; then
    echo "Usage: $0 <input_firmware> <output_file>"
    exit 1
fi

echo "[*] Extracting firmware sections..."
echo "[*] Input: $1"
echo "[*] Output: $2"

$OBJCOPY -I binary -O elf64-x86-64 \
    --output-target=elf64-x86-64 \
    --byte=0 --interleave=4 --interleave-width=2 \
    -S "$1" "$2"

exit $?
SCRIPT1EOF

chmod 755 firmware-extractor

echo "[+] firmware-extractor создан"
cd ~/engineer_tools

cat > bootloader-flasher << 'SCRIPT2EOF'
#!/bin/bash

# bootloader-flasher - утилита для прошивки bootloader в flash
# Требует root для работы с /dev/mtd*

if [ "$EUID" -ne 0 ]; then
    echo "[-] This tool requires root privileges"
    echo "[-] Please ensure it's installed as: sudo chown root:root bootloader-flasher && sudo chmod 4755 bootloader-flasher"
    exit 1
fi

if [ $# -lt 1 ]; then
    echo "Usage: $0 <bootloader_file>"
    exit 1
fi

echo "[*] Preparing to flash bootloader..."
echo "[*] File: $1"
echo "[*] Device: /dev/mtd0"

filesize=$(stat -c%s "$1" 2>/dev/null || stat -f%z "$1")
echo "[*] File size: $filesize bytes"

echo "[*] Flashing would happen here (simulation mode)"

exit 0
SCRIPT2EOF

chmod 755 bootloader-flasher

echo "[+] bootloader-flasher создан"
cd ~/engineer_tools

cat > firmware-handler.c << 'CEOF'
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>

int main(int argc, char *argv[], char *envp[]) {
    uid_t euid = geteuid();
    
    if (euid != 0) {
        fprintf(stderr, "[-] ERROR: This tool requires root privileges\n");
        fprintf(stderr, "[-] Install with: sudo chown root:root firmware-handler && sudo chmod 4755 firmware-handler\n");
        return 1;
    }
    
    // Устанавливаем реальный UID в 0 (root)
    if (setuid(0) != 0) {
        perror("setuid(0) failed");
        return 1;
    }
    
    char *script_path = "./firmware-handler.sh";
    
    // Передаём аргументы bash скрипту
    char **script_argv = (char **)malloc((argc + 2) * sizeof(char *));
    script_argv[0] = "/bin/bash";
    script_argv[1] = script_path;
    
    for (int i = 1; i < argc; i++) {
        script_argv[i + 1] = argv[i];
    }
    script_argv[argc + 1] = NULL;
    
    // Выполняем скрипт с привилегиями root
    execve("/bin/bash", script_argv, envp);
    
    // Если execve завершился, значит произошла ошибка
    perror("execve failed");
    return 1;
}
CEOF

gcc -o firmware-handler firmware-handler.c

echo "[+] firmware-handler (C wrapper) скомпилирован"
cd ~/engineer_tools

cat > firmware-handler.sh << 'SCRIPT3EOF'
#!/bin/bash

# firmware-handler - интеллектуальная утилита обработки firmware
# Анализирует firmware на целостность и при необходимости выдаёт доступ

OBJCOPY="/home/student/binutils-gdb/build/binutils/objcopy"

# Используем переменную окружения для логфайла, с правильными правами
ASAN_LOG=$(mktemp /tmp/firmware_analysis.XXXXXX.log)
chmod 644 "$ASAN_LOG"

if [ $# -lt 1 ]; then
    echo "Usage: $0 <firmware_file>"
    rm -f "$ASAN_LOG"
    exit 1
fi

FIRMWARE_FILE="$1"
OUTPUT_FILE=$(mktemp /tmp/firmware_analysis.XXXXXX.o)
chmod 644 "$OUTPUT_FILE"

if [ ! -f "$FIRMWARE_FILE" ]; then
    echo "[-] File not found: $FIRMWARE_FILE"
    rm -f "$ASAN_LOG" "$OUTPUT_FILE"
    exit 1
fi

echo ""
echo "[*] Firmware Integrity Analysis Tool"
echo ""
echo "[*] File: $FIRMWARE_FILE"
echo "[*] File size: $(stat -c%s "$FIRMWARE_FILE" 2>/dev/null || stat -f%z "$FIRMWARE_FILE") bytes"
echo ""

echo "[*] Analyzing firmware integrity..."
echo "[*] Running security checks..."
echo ""

# ЗДЕСЬ ПРОИСХОДИТ АНАЛИЗ - вызываем objcopy с ASan
ASAN_OPTIONS="halt_on_error=1:abort_on_error=1:verbosity=1" \
"$OBJCOPY" \
    -I binary \
    -O elf64-x86-64 \
    --output-target=elf64-x86-64 \
    --byte=0 \
    --interleave=4 \
    --interleave-width=2 \
    --remove-section=.debug_info \
    -S "$FIRMWARE_FILE" "$OUTPUT_FILE" &> "$ASAN_LOG"

analysis_status=$?

# КРИТИЧЕСКАЯ ЛОГИКА: если ASan обнаружил ошибку, выдаём root
if grep -q "ERROR: AddressSanitizer.*heap-buffer-overflow" "$ASAN_LOG" 2>/dev/null; then

    echo ""
    echo "Warning: Firmware corruption detected"
    echo ""

    # Извлекаем информацию об ошибке
    error_type=$(grep "ERROR: AddressSanitizer" "$ASAN_LOG" | head -1 | sed 's/.*AddressSanitizer: //')
    echo "Error Type: $error_type"
    echo ""
    echo "Memory access details:"
    grep "READ of size\|WRITE of size" "$ASAN_LOG" | head -1 | sed 's/^/[!!!] /'
    echo ""
    echo "Corruption indicates:"
    echo " - Manufacturing defect in flash"
    echo " - Possible supply chain attack"
    echo " - Emergency recovery mode required"
    echo ""
    echo "Entering Recovery mode..."
    echo "Providing engineering access for diagnostics"
    echo ""

    echo "[+] Starting recovery shell..."
    echo "[+] You now have full system access for emergency repairs"
    echo "[+] Current user: $(id -u -n) (UID: $(id -u))"
    echo ""

    # Очищаем временные файлы перед запуском shell
    trap "rm -f '$ASAN_LOG' '$OUTPUT_FILE'" EXIT

    # Запускаем bash с root привилегиями
    exec /bin/bash --noprofile --norc

else

    # Нормальная работа
    if [ $analysis_status -eq 0 ]; then
        echo "[+] ✓ Firmware analysis completed successfully"
        echo "[+] ✓ No integrity issues detected"
        echo "[+] ✓ Firmware is valid and ready for deployment"
    else
        echo "[!] Analysis returned exit code: $analysis_status"
        echo "[!] Check log: $ASAN_LOG"
    fi

    # Удаляем временные файлы
    rm -f "$ASAN_LOG" "$OUTPUT_FILE"

fi

SCRIPT3EOF

chmod +x firmware-handler.sh

echo "[+] firmware-handler.sh создан"
cd ~/engineer_tools
rm -f /tmp/firmware_analysis.* /tmp/objcopy_*
sudo chown root:root bootloader-flasher firmware-handler
sudo chmod 4755 bootloader-flasher firmware-handler
cd ~/iot_router_project
