# CVE-2025-70886

A Proof of Concept (PoC) exploit for [CVE-2025-70886](https://www.cve.org/CVERecord?id=CVE-2025-70886), a persistent denial-of-service vulnerability in Halo CMS (v2.22.4 and earlier) that allows remote attackers to crash the admin comment interface by submitting malformed payloads.

## Basic Information

- Product Vendor: 凌霞软件
- Vendor Website: https://www.lxware.cn/
- Affected Object Type: Software / Web application
- Affected Product: [Halo CMS](https://github.com/halo-dev/halo)
- Affected Product Versions: <= v2.22.4
- Vulnerability type: Persistent DoS (Stored DoS) / Unhandled Exception
- Attack type: Remote
- Impact: Denial of Service (admin comment page returns HTTP 500 / Internal Server Error)

## Vulnerability Overview

An issue in Halo v2.22.4 and earlier allows a remote attacker to cause a denial of service via a crafted payload to the public comment submission endpoint.

## Details of the vulnerability

An attacker can submit a crafted/malformed comment payload (missing fields such as `subjectRef.version`) via the public comment submission endpoint. The malformed comment is stored and later triggers an unhandled exception when the admin comment page reads/renders it, resulting in a persistent denial of service for the comment management page until the offending record is removed or server-side validation/handling is fixed.

- Impact: Admin comment page becomes unavailable (HTTP 500 / Internal Server Error) after a malformed comment is submitted and stored; recovery may require manual database cleanup or deletion via API.

## What this repo contains

- A [workflow](.github/workflows/cve-2025-70886-audit.yml) that boots Halo and records a result per version.
- [Minimal tooling](src/poc.js) to send a test comment request.

### What the workflow does

1. Download and start a specified Halo version.
2. Initialize the system.
3. Configure the comment system.
4. Send a test request and check the comments API response.
5. Save a per-version result and publish a final summary.

### Audit results

At the end of the run, the **Summary** job publishes a table showing each Halo version and its status:

- `likely_vulnerable` — API returned HTTP 500 during the check.
- `not_confirmed` — API did not return HTTP 500.

Results: https://github.com/HowieHz/CVE-2025-70886/actions/runs/21742076721

## Manual Reproduction Steps

**⚠️ Warning: For authorized testing environments only**

1. Clone the PoC repository
   ```bash
   git clone https://github.com/HowieHz/CVE-2025-70886
   cd CVE-2025-70886
   ```

2. Deploy a Halo CMS test instance
   - Follow the [official Halo documentation](https://docs.halo.run/) to deploy a vulnerable version (<= v2.22.4) of Halo CMS
   - Default address: http://localhost:8090

3. Initialize the system
   - Access the Halo console to complete the initial setup.
   - Configure the comment system:
     - Navigate to http://localhost:8090/console/settings?tab=comment
     - Ensure "Allow comments from registered users only"（仅允许注册用户评论） is **disabled** (If login is required to comment, you can reproduce the issue using the method described at [blog](https://howiehz.top/archives/halo-comment-payload-tweaker-en) instead of running the PoC script below.)
     - Ensure "Enable comments"（启用评论） is **enabled**

4. Execute the PoC script (Ensure the Node.js environment is configured.)
   ```bash
   node src/poc.js --base-url http://localhost:8090 --payload fixtures/payload.sample.json
   ```

   Available options:
   - `--base-url`: Halo site base URL (e.g., http://localhost:8090)
   - `--payload`: Path to a captured, valid comment payload JSON file
   - `--dry-run`: Only print modified payload, do not send
   - `--header`: Extra header in 'Key: Value' form (repeatable)
   - `--help`: Show help

5. Verify the vulnerability
   - Visit the admin comment page: http://localhost:8090/console/comments
   - If **Internal Server Error (HTTP 500)** appears, the vulnerability is confirmed

## References

- https://github.com/halo-dev/halo/issues/7890
- https://howiehz.top/archives/halo-comment-payload-tweaker-en
