# CVE-2025-70829：Datart 信息泄露漏洞

## 1. 漏洞概述

**CVE ID**: CVE-2025-70829  
**影响产品**: Datart  
**版本**: v1.0.0-rc.3  
**漏洞类型**: 信息泄露 (Information Exposure)

Datart v1.0.0-rc.3 存在信息泄露漏洞，允许经过身份验证的攻击者通过自定义 H2 JDBC 连接字符串访问敏感数据。通过引导应用程序连接到自身的内部数据库文件，攻击者可以查询包含用户凭据和配置详情的系统表。

---

## 2. 复现步骤

### 前置条件

- 已拥有登录 Datart 仪表板的权限。

### 操作步骤

1. **登录** 到 Datart 系统 (v1.0.0-rc.3)。
2. 导航到 **"数据源"** 模块。
3. 点击 **新建数据源** 并选择类型 **"H2"**。
4. 在配置中，输入以下恶意的 JDBC URL 指向本地内部数据库文件：
   ```text
   jdbc:h2:file:./bin/h2/datart.demo;MODE=MySQL
   ```
5. 点击 **"测试连接"** 确认可以访问内部系统数据库。
6. 保存该数据源。
7. 使用 SQL 编辑器（或使用此数据源创建图表）执行任意查询。

---

## 3. 敏感信息获取

### 获取用户凭据并伪造 JWT

通过从数据库中检索用户的密码哈希值，攻击者可以伪造有效的 JWT 令牌来冒充任何用户（例如管理员）。这是因为应用程序使用了硬编码的密钥 (`d@a$t%a^r&a*t`)，并且在令牌载荷中包含了密码哈希的 Java `hashCode()`。

**SQL 查询:**

```sql
SELECT id, username, email, password, name FROM user;
```

> **利用方法**: 使用获取到的 `password` 哈希配合 `jwttest.py` 生成有效的 `Bearer` 令牌，以实现任意用户登录。

### 获取并解密数据源配置

攻击者还可以检索其他已连接数据源的配置信息。

**SQL 查询:**

```sql
SELECT * FROM source;
```

**解密:**

`source` 表中的 `config` 字段通常使用 AES 加密。应用程序使用了一个默认的硬编码安全密钥：

> **默认安全密钥**: `d@a$t%a^r&a*t`

您可以使用提供的 [Decrypt.java](Decrypt.java) 工具（其中已包含此默认密钥）来解密这些值，从而获取外部数据库的明文凭据。

### 使用示例

1. 将数据库中的加密字符串提供给 `Decrypt.java`。
2. 运行 Java 程序以显示连接详情（URL、用户名、密码）。
